/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.conn;

import io.hops.hudi.org.apache.http.HttpException;
import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.HttpRequest;
import io.hops.hudi.org.apache.http.ProtocolException;
import io.hops.hudi.org.apache.http.annotation.Immutable;
import io.hops.hudi.org.apache.http.client.config.RequestConfig;
import io.hops.hudi.org.apache.http.client.protocol.HttpClientContext;
import io.hops.hudi.org.apache.http.conn.SchemePortResolver;
import io.hops.hudi.org.apache.http.conn.UnsupportedSchemeException;
import io.hops.hudi.org.apache.http.conn.routing.HttpRoute;
import io.hops.hudi.org.apache.http.conn.routing.HttpRoutePlanner;
import io.hops.hudi.org.apache.http.impl.conn.DefaultSchemePortResolver;
import io.hops.hudi.org.apache.http.protocol.HttpContext;
import io.hops.hudi.org.apache.http.util.Args;
import java.net.InetAddress;

@Immutable
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        if (proxy == null) {
            return new HttpRoute(target, local, secure);
        }
        return new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

