/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.parquet.avro;

import io.hops.hudi.org.apache.avro.Schema;
import io.hops.hudi.org.apache.avro.generic.GenericData;
import io.hops.hudi.org.apache.avro.util.Utf8;
import io.hops.hudi.org.apache.parquet.avro.ParentValueContainer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;

public class AvroConverters {

    static final class FieldFixedConverter
    extends BinaryConverter<Object> {
        private final Schema schema;
        private final GenericData model;

        public FieldFixedConverter(ParentValueContainer parent, Schema avroSchema, GenericData model) {
            super(parent);
            this.schema = avroSchema;
            this.model = model;
        }

        @Override
        public Object convert(Binary binary) {
            return this.model.createFixed(null, binary.getBytes(), this.schema);
        }
    }

    static final class FieldEnumConverter
    extends BinaryConverter<Object> {
        private final Schema schema;
        private final GenericData model;

        public FieldEnumConverter(ParentValueContainer parent, Schema enumSchema, GenericData model) {
            super(parent);
            this.schema = enumSchema;
            this.model = model;
        }

        @Override
        public Object convert(Binary binary) {
            return this.model.createEnum(binary.toStringUsingUTF8(), this.schema);
        }
    }

    static final class FieldStringableConverter
    extends BinaryConverter<Object> {
        private final String stringableName;
        private final Constructor<?> ctor;

        public FieldStringableConverter(ParentValueContainer parent, Class<?> stringableClass) {
            super(parent);
            this.stringableName = stringableClass.getName();
            try {
                this.ctor = stringableClass.getConstructor(String.class);
            }
            catch (NoSuchMethodException e) {
                throw new ParquetDecodingException("Unable to get String constructor for " + this.stringableName, (Throwable)e);
            }
        }

        @Override
        public Object convert(Binary binary) {
            try {
                return this.ctor.newInstance(binary.toStringUsingUTF8());
            }
            catch (InstantiationException e) {
                throw new ParquetDecodingException("Cannot convert binary to " + this.stringableName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ParquetDecodingException("Cannot convert binary to " + this.stringableName, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ParquetDecodingException("Cannot convert binary to " + this.stringableName, (Throwable)e);
            }
        }
    }

    static final class FieldUTF8Converter
    extends BinaryConverter<Utf8> {
        public FieldUTF8Converter(ParentValueContainer parent) {
            super(parent);
        }

        @Override
        public Utf8 convert(Binary binary) {
            return new Utf8(binary.getBytes());
        }
    }

    static final class FieldStringConverter
    extends BinaryConverter<String> {
        public FieldStringConverter(ParentValueContainer parent) {
            super(parent);
        }

        @Override
        public String convert(Binary binary) {
            return binary.toStringUsingUTF8();
        }
    }

    static final class FieldByteBufferConverter
    extends BinaryConverter<ByteBuffer> {
        public FieldByteBufferConverter(ParentValueContainer parent) {
            super(parent);
        }

        @Override
        public ByteBuffer convert(Binary binary) {
            return ByteBuffer.wrap(binary.getBytes());
        }
    }

    static final class FieldByteArrayConverter
    extends BinaryConverter<byte[]> {
        public FieldByteArrayConverter(ParentValueContainer parent) {
            super(parent);
        }

        @Override
        public byte[] convert(Binary binary) {
            return binary.getBytes();
        }
    }

    static final class FieldDoubleConverter
    extends AvroPrimitiveConverter {
        public FieldDoubleConverter(ParentValueContainer parent) {
            super(parent);
        }

        public final void addInt(int value) {
            this.parent.addDouble(value);
        }

        public final void addLong(long value) {
            this.parent.addDouble(value);
        }

        public final void addFloat(float value) {
            this.parent.addDouble(value);
        }

        public final void addDouble(double value) {
            this.parent.addDouble(value);
        }
    }

    static final class FieldFloatConverter
    extends AvroPrimitiveConverter {
        public FieldFloatConverter(ParentValueContainer parent) {
            super(parent);
        }

        public final void addInt(int value) {
            this.parent.addFloat(value);
        }

        public final void addLong(long value) {
            this.parent.addFloat(value);
        }

        public final void addFloat(float value) {
            this.parent.addFloat(value);
        }
    }

    static final class FieldLongConverter
    extends AvroPrimitiveConverter {
        public FieldLongConverter(ParentValueContainer parent) {
            super(parent);
        }

        public final void addInt(int value) {
            this.parent.addLong(value);
        }

        public final void addLong(long value) {
            this.parent.addLong(value);
        }
    }

    static final class FieldIntegerConverter
    extends AvroPrimitiveConverter {
        public FieldIntegerConverter(ParentValueContainer parent) {
            super(parent);
        }

        public final void addInt(int value) {
            this.parent.addInt(value);
        }
    }

    static final class FieldBooleanConverter
    extends AvroPrimitiveConverter {
        public FieldBooleanConverter(ParentValueContainer parent) {
            super(parent);
        }

        public final void addBoolean(boolean value) {
            this.parent.addBoolean(value);
        }
    }

    static final class FieldCharConverter
    extends AvroPrimitiveConverter {
        public FieldCharConverter(ParentValueContainer parent) {
            super(parent);
        }

        public void addInt(int value) {
            this.parent.addChar((char)value);
        }
    }

    static final class FieldShortConverter
    extends AvroPrimitiveConverter {
        public FieldShortConverter(ParentValueContainer parent) {
            super(parent);
        }

        public void addInt(int value) {
            this.parent.addShort((short)value);
        }
    }

    static final class FieldByteConverter
    extends AvroPrimitiveConverter {
        public FieldByteConverter(ParentValueContainer parent) {
            super(parent);
        }

        public void addInt(int value) {
            this.parent.addByte((byte)value);
        }
    }

    static abstract class BinaryConverter<T>
    extends AvroPrimitiveConverter {
        private T[] dict = null;

        public BinaryConverter(ParentValueContainer parent) {
            super(parent);
        }

        public abstract T convert(Binary var1);

        public void addBinary(Binary value) {
            this.parent.add(this.convert(value));
        }

        public boolean hasDictionarySupport() {
            return true;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new Object[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this.dict[i] = this.convert(dictionary.decodeToBinary(i));
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }
    }

    static class AvroPrimitiveConverter
    extends PrimitiveConverter {
        protected final ParentValueContainer parent;

        public AvroPrimitiveConverter(ParentValueContainer parent) {
            this.parent = parent;
        }
    }

    public static abstract class AvroGroupConverter
    extends GroupConverter {
        protected final ParentValueContainer parent;

        public AvroGroupConverter(ParentValueContainer parent) {
            this.parent = parent;
        }
    }
}

