/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;

public class MergingIterator<T extends GenericRecord>
implements Iterator<T> {
    private final Iterator<T> leftIterator;
    private final Iterator<T> rightIterator;
    private final Function<Pair<T, T>, T> mergeFunction;

    public MergingIterator(Iterator<T> leftIterator, Iterator<T> rightIterator, Function<Pair<T, T>, T> mergeFunction) {
        this.leftIterator = leftIterator;
        this.rightIterator = rightIterator;
        this.mergeFunction = mergeFunction;
    }

    @Override
    public boolean hasNext() {
        boolean rightHasNext;
        boolean leftHasNext = this.leftIterator.hasNext();
        ValidationUtils.checkArgument(leftHasNext == (rightHasNext = this.rightIterator.hasNext()));
        return leftHasNext;
    }

    @Override
    public T next() {
        return (T)((GenericRecord)this.mergeFunction.apply(Pair.of(this.leftIterator.next(), this.rightIterator.next())));
    }
}

