/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import io.hops.hudi.org.apache.avro.Schema;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableSchema
implements Serializable {
    private transient Schema schema;

    public SerializableSchema() {
    }

    public SerializableSchema(Schema schema) {
        this.schema = SerializableSchema.newCopy(schema);
    }

    public SerializableSchema(SerializableSchema serializableSchema) {
        this(serializableSchema.schema);
    }

    public static Schema newCopy(Schema schemaObject) {
        return new Schema.Parser().parse(schemaObject.toString());
    }

    public Schema get() {
        return this.schema;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeObjectTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.readObjectFrom(in);
    }

    public void writeObjectTo(ObjectOutputStream out) throws IOException {
        out.writeObject(this.schema.toString());
    }

    public void readObjectFrom(ObjectInputStream in) throws IOException {
        try {
            this.schema = new Schema.Parser().parse(in.readObject().toString());
        }
        catch (ClassNotFoundException e) {
            throw new IOException("unable to parse schema", e);
        }
    }

    public String toString() {
        return this.schema.toString();
    }
}

