/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import io.hops.hudi.org.apache.avro.Schema;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.table.BulkInsertPartitioner;

public class JavaCustomColumnsSortPartitioner<T extends HoodieRecordPayload>
implements BulkInsertPartitioner<List<HoodieRecord<T>>> {
    private final String[] sortColumnNames;
    private final Schema schema;
    private final boolean consistentLogicalTimestampEnabled;

    public JavaCustomColumnsSortPartitioner(String[] columnNames, Schema schema, boolean consistentLogicalTimestampEnabled) {
        this.sortColumnNames = columnNames;
        this.schema = schema;
        this.consistentLogicalTimestampEnabled = consistentLogicalTimestampEnabled;
    }

    @Override
    public List<HoodieRecord<T>> repartitionRecords(List<HoodieRecord<T>> records, int outputPartitions) {
        return records.stream().sorted((o1, o2) -> {
            Object values1 = HoodieAvroUtils.getRecordColumnValues((HoodieRecord<? extends HoodieRecordPayload>)o1, this.sortColumnNames, this.schema, this.consistentLogicalTimestampEnabled);
            Object values2 = HoodieAvroUtils.getRecordColumnValues((HoodieRecord<? extends HoodieRecordPayload>)o2, this.sortColumnNames, this.schema, this.consistentLogicalTimestampEnabled);
            return values1.toString().compareTo(values2.toString());
        }).collect(Collectors.toList());
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

