/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.exception.HoodieException;

@ThreadSafe
public class CachingPath
extends Path {
    private volatile Path parent;
    private volatile String fileName;
    private volatile String fullPathStr;

    public CachingPath(String parent, String child) {
        super(parent, child);
    }

    public CachingPath(Path parent, String child) {
        super(parent, child);
    }

    public CachingPath(String parent, Path child) {
        super(parent, child);
    }

    public CachingPath(Path parent, Path child) {
        super(parent, child);
    }

    public CachingPath(String pathString) throws IllegalArgumentException {
        super(pathString);
    }

    public CachingPath(URI aUri) {
        super(aUri);
    }

    public String getName() {
        if (this.fileName == null) {
            this.fileName = super.getName();
        }
        return this.fileName;
    }

    public Path getParent() {
        if (this.parent == null) {
            this.parent = super.getParent();
        }
        return this.parent;
    }

    public String toString() {
        if (this.fullPathStr == null) {
            this.fullPathStr = super.toString();
        }
        return this.fullPathStr;
    }

    public CachingPath subPath(String relativePath) {
        return new CachingPath((Path)this, (Path)CachingPath.createPathUnsafe(relativePath));
    }

    public static CachingPath wrap(Path path) {
        if (path instanceof CachingPath) {
            return (CachingPath)path;
        }
        return new CachingPath(path.toUri());
    }

    public static CachingPath createPathUnsafe(String relativePath) {
        try {
            URI uri = new URI(null, null, relativePath, null, null);
            return new CachingPath(uri);
        }
        catch (URISyntaxException e) {
            throw new HoodieException("Failed to instantiate relative path", e);
        }
    }

    public static Path getPathWithoutSchemeAndAuthority(Path path) {
        return path.isUriPathAbsolute() ? CachingPath.createPathUnsafe(path.toUri().getPath()) : path;
    }
}

