/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBaseBloomIndexCheckFunction;
import org.apache.hudi.io.HoodieKeyLookupResult;
import org.apache.hudi.table.HoodieTable;

public class ListBasedHoodieBloomIndexHelper
extends BaseHoodieBloomIndexHelper {
    private static final ListBasedHoodieBloomIndexHelper SINGLETON_INSTANCE = new ListBasedHoodieBloomIndexHelper();

    protected ListBasedHoodieBloomIndexHelper() {
    }

    public static ListBasedHoodieBloomIndexHelper getInstance() {
        return SINGLETON_INSTANCE;
    }

    @Override
    public HoodiePairData<HoodieKey, HoodieRecordLocation> findMatchingFilesForRecordKeys(HoodieWriteConfig config, HoodieEngineContext context, HoodieTable hoodieTable, HoodiePairData<String, String> partitionRecordKeyPairs, HoodieData<Pair<String, HoodieKey>> fileComparisonPairs, Map<String, List<BloomIndexFileInfo>> partitionToFileInfo, Map<String, Long> recordsPerPartition) {
        List fileComparisonPairList = fileComparisonPairs.collectAsList().stream().sorted(Comparator.comparing(Pair::getLeft)).collect(Collectors.toList());
        List<Object> keyLookupResults = new ArrayList();
        Iterator<List<HoodieKeyLookupResult>> iterator = new HoodieBaseBloomIndexCheckFunction(hoodieTable, config).apply(fileComparisonPairList.iterator());
        while (iterator.hasNext()) {
            keyLookupResults.addAll(iterator.next());
        }
        keyLookupResults = keyLookupResults.stream().filter(lr -> lr.getMatchingRecordKeys().size() > 0).collect(Collectors.toList());
        return context.parallelize(keyLookupResults).flatMap(lookupResult -> lookupResult.getMatchingRecordKeys().stream().map(recordKey -> new ImmutablePair<HoodieKeyLookupResult, String>((HoodieKeyLookupResult)lookupResult, (String)recordKey)).iterator()).mapToPair(pair -> {
            HoodieKeyLookupResult lookupResult = (HoodieKeyLookupResult)pair.getLeft();
            String recordKey = (String)pair.getRight();
            return new ImmutablePair<HoodieKey, HoodieRecordLocation>(new HoodieKey(recordKey, lookupResult.getPartitionPath()), new HoodieRecordLocation(lookupResult.getBaseInstantTime(), lookupResult.getFileId()));
        });
    }
}

