/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.table.HoodieTable;

public abstract class HoodieReadHandle<T extends HoodieRecordPayload, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    protected final Pair<String, String> partitionPathFileIDPair;

    public HoodieReadHandle(HoodieWriteConfig config, HoodieTable<T, I, K, O> hoodieTable, Pair<String, String> partitionPathFileIDPair) {
        super(config, Option.empty(), hoodieTable);
        this.partitionPathFileIDPair = partitionPathFileIDPair;
    }

    @Override
    protected FileSystem getFileSystem() {
        return this.hoodieTable.getMetaClient().getFs();
    }

    public Pair<String, String> getPartitionPathFileIDPair() {
        return this.partitionPathFileIDPair;
    }

    public String getFileId() {
        return this.partitionPathFileIDPair.getRight();
    }

    protected HoodieBaseFile getLatestDataFile() {
        return this.hoodieTable.getBaseFileOnlyView().getLatestBaseFile(this.partitionPathFileIDPair.getLeft(), this.partitionPathFileIDPair.getRight()).get();
    }

    protected HoodieFileReader createNewFileReader() throws IOException {
        return HoodieFileReaderFactory.getFileReader(this.hoodieTable.getHadoopConf(), new Path(this.getLatestDataFile().getPath()));
    }
}

