/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import io.hops.hudi.org.apache.avro.generic.IndexedRecord;
import java.io.IOException;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;

public interface HoodieFileWriter<R extends IndexedRecord> {
    public void writeAvroWithMetadata(HoodieKey var1, R var2) throws IOException;

    public boolean canWrite();

    public void close() throws IOException;

    public void writeAvro(String var1, R var2) throws IOException;

    default public void prepRecordWithMetadata(HoodieKey key, R avroRecord, String instantTime, Integer partitionId, long recordIndex, String fileName) {
        String seqId = HoodieRecord.generateSequenceId(instantTime, partitionId, recordIndex);
        HoodieAvroUtils.addHoodieKeyToRecord((GenericRecord)avroRecord, key.getRecordKey(), key.getPartitionPath(), fileName);
        HoodieAvroUtils.addCommitMetadataToRecord((GenericRecord)avroRecord, instantTime, seqId);
    }
}

