/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import io.hops.hudi.org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFileInfo;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.ReaderContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.io.storage.HoodieHFileReader;

public class HoodieHFileUtils {
    private static final boolean USE_PRIMARY_REPLICA_READER = true;

    public static HFile.Reader createHFileReader(FileSystem fs, Path path, CacheConfig cacheConfig, Configuration configuration) throws IOException {
        return HFile.createReader(fs, path, cacheConfig, true, configuration);
    }

    public static HFile.Reader createHFileReader(FileSystem fs, Path dummyPath, byte[] content) throws IOException {
        Configuration conf = new Configuration(false);
        HoodieHFileReader.SeekableByteArrayInputStream bis = new HoodieHFileReader.SeekableByteArrayInputStream(content);
        FSDataInputStream fsdis = new FSDataInputStream((InputStream)bis);
        FSDataInputStreamWrapper stream = new FSDataInputStreamWrapper(fsdis);
        ReaderContext context = new ReaderContextBuilder().withFilePath(dummyPath).withInputStreamWrapper(stream).withFileSize(content.length).withFileSystem(fs).withPrimaryReplicaReader(true).withReaderType(ReaderContext.ReaderType.STREAM).build();
        HFileInfo fileInfo = new HFileInfo(context, conf);
        HFile.Reader reader = HFile.createReader(context, fileInfo, new CacheConfig(conf), conf);
        fileInfo.initMetaAndIndex(reader);
        return reader;
    }
}

