/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.ConsoleMetricsReporter;
import org.apache.hudi.metrics.InMemoryMetricsReporter;
import org.apache.hudi.metrics.JmxMetricsReporter;
import org.apache.hudi.metrics.MetricsGraphiteReporter;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.cloudwatch.CloudWatchMetricsReporter;
import org.apache.hudi.metrics.custom.CustomizableMetricsReporter;
import org.apache.hudi.metrics.datadog.DatadogMetricsReporter;
import org.apache.hudi.metrics.prometheus.PrometheusReporter;
import org.apache.hudi.metrics.prometheus.PushGatewayMetricsReporter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MetricsReporterFactory {
    private static final Logger LOG = LogManager.getLogger(MetricsReporterFactory.class);

    public static MetricsReporter createReporter(HoodieWriteConfig config, MetricRegistry registry) {
        String reporterClassName = config.getMetricReporterClassName();
        if (!StringUtils.isNullOrEmpty(reporterClassName)) {
            Object instance = ReflectionUtils.loadClass(reporterClassName, new Class[]{Properties.class, MetricRegistry.class}, new Object[]{config.getProps(), registry});
            if (!(instance instanceof CustomizableMetricsReporter)) {
                throw new HoodieException(config.getMetricReporterClassName() + " is not a subclass of CustomizableMetricsReporter");
            }
            return (MetricsReporter)instance;
        }
        MetricsReporterType type = config.getMetricsReporterType();
        MetricsReporter reporter = null;
        switch (type) {
            case GRAPHITE: {
                reporter = new MetricsGraphiteReporter(config, registry);
                break;
            }
            case INMEMORY: {
                reporter = new InMemoryMetricsReporter();
                break;
            }
            case JMX: {
                reporter = new JmxMetricsReporter(config, registry);
                break;
            }
            case DATADOG: {
                reporter = new DatadogMetricsReporter(config, registry);
                break;
            }
            case PROMETHEUS_PUSHGATEWAY: {
                reporter = new PushGatewayMetricsReporter(config, registry);
                break;
            }
            case PROMETHEUS: {
                reporter = new PrometheusReporter(config, registry);
                break;
            }
            case CONSOLE: {
                reporter = new ConsoleMetricsReporter(registry);
                break;
            }
            case CLOUDWATCH: {
                reporter = new CloudWatchMetricsReporter(config, registry);
                break;
            }
            default: {
                LOG.error((Object)("Reporter type[" + (Object)((Object)type) + "] is not supported."));
            }
        }
        return reporter;
    }
}

