/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import io.hops.hudi.org.apache.avro.Schema;
import java.io.Serializable;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public abstract class ClusteringExecutionStrategy<T extends HoodieRecordPayload, I, K, O>
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(ClusteringExecutionStrategy.class);
    private final HoodieTable<T, I, K, O> hoodieTable;
    private final transient HoodieEngineContext engineContext;
    private final HoodieWriteConfig writeConfig;

    public ClusteringExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
        this.hoodieTable = table;
        this.engineContext = engineContext;
    }

    public abstract HoodieWriteMetadata<O> performClustering(HoodieClusteringPlan var1, Schema var2, String var3);

    protected HoodieTable<T, I, K, O> getHoodieTable() {
        return this.hoodieTable;
    }

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    protected HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }
}

