/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.HoodieCompactor;

public class HoodieJavaMergeOnReadTableCompactor<T extends HoodieRecordPayload>
extends HoodieCompactor<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    @Override
    public void preCompact(HoodieTable table, HoodieTimeline pendingCompactionTimeline, String compactionInstantTime) {
        HoodieInstant inflightInstant = HoodieTimeline.getCompactionInflightInstant(compactionInstantTime);
        if (pendingCompactionTimeline.containsInstant(inflightInstant)) {
            table.rollbackInflightCompaction(inflightInstant);
            table.getMetaClient().reloadActiveTimeline();
        }
    }

    @Override
    public void maybePersist(HoodieData<WriteStatus> writeStatus, HoodieWriteConfig config) {
    }
}

