/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.roaringbitmap;

import io.hops.hudi.org.roaringbitmap.ArrayContainer;
import io.hops.hudi.org.roaringbitmap.PeekableCharRankIterator;
import io.hops.hudi.org.roaringbitmap.Util;

final class ArrayContainerCharIterator
implements PeekableCharRankIterator {
    int pos;
    private ArrayContainer parent;

    ArrayContainerCharIterator() {
    }

    ArrayContainerCharIterator(ArrayContainer p) {
        this.wrap(p);
    }

    @Override
    public void advanceIfNeeded(char minval) {
        this.pos = Util.advanceUntil(this.parent.content, this.pos - 1, this.parent.cardinality, minval);
    }

    @Override
    public int peekNextRank() {
        return this.pos + 1;
    }

    @Override
    public PeekableCharRankIterator clone() {
        try {
            return (PeekableCharRankIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.cardinality;
    }

    @Override
    public char next() {
        return this.parent.content[this.pos++];
    }

    @Override
    public int nextAsInt() {
        return this.parent.content[this.pos++];
    }

    @Override
    public char peekNext() {
        return this.parent.content[this.pos];
    }

    @Override
    public void remove() {
        this.parent.removeAtIndex(this.pos - 1);
        --this.pos;
    }

    void wrap(ArrayContainer p) {
        this.parent = p;
        this.pos = 0;
    }
}

