/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerQuotaSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.hbase.regionserver.MetricsTable;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsUserAggregateFactory;
import org.apache.hadoop.hbase.regionserver.RegionServerTableMetrics;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceStability.Evolving
@InterfaceAudience.Private
public class MetricsRegionServer {
    public static final String RS_ENABLE_TABLE_METRICS_KEY = "hbase.regionserver.enable.table.latencies";
    public static final boolean RS_ENABLE_TABLE_METRICS_DEFAULT = true;
    public static final String RS_ENABLE_SERVER_QUERY_METER_METRICS_KEY = "hbase.regionserver.enable.server.query.meter";
    public static final boolean RS_ENABLE_SERVER_QUERY_METER_METRICS_KEY_DEFAULT = true;
    public static final String RS_ENABLE_TABLE_QUERY_METER_METRICS_KEY = "hbase.regionserver.enable.table.query.meter";
    public static final boolean RS_ENABLE_TABLE_QUERY_METER_METRICS_KEY_DEFAULT = true;
    public static final String SLOW_METRIC_TIME = "hbase.ipc.slow.metric.time";
    private final MetricsRegionServerSource serverSource;
    private final MetricsRegionServerWrapper regionServerWrapper;
    private RegionServerTableMetrics tableMetrics;
    private final MetricsTable metricsTable;
    private final MetricsUserAggregate userAggregate;
    private MetricsRegionServerQuotaSource quotaSource;
    private MetricRegistry metricRegistry;
    private Timer bulkLoadTimer;
    private Meter serverReadQueryMeter;
    private Meter serverWriteQueryMeter;
    protected long slowMetricTime;
    protected static final int DEFAULT_SLOW_METRIC_TIME = 1000;

    public MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, Configuration conf, MetricsTable metricsTable) {
        this(regionServerWrapper, CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createServer(regionServerWrapper), MetricsRegionServer.createTableMetrics(conf), metricsTable, MetricsUserAggregateFactory.getMetricsUserAggregate(conf));
        this.metricRegistry = MetricRegistries.global().get(this.serverSource.getMetricRegistryInfo()).get();
        this.bulkLoadTimer = this.metricRegistry.timer("Bulkload");
        this.slowMetricTime = conf.getLong(SLOW_METRIC_TIME, 1000L);
        this.quotaSource = CompatibilitySingletonFactory.getInstance(MetricsRegionServerQuotaSource.class);
        if (conf.getBoolean(RS_ENABLE_SERVER_QUERY_METER_METRICS_KEY, true)) {
            this.serverReadQueryMeter = this.metricRegistry.meter("ServerReadQueryPerSecond");
            this.serverWriteQueryMeter = this.metricRegistry.meter("ServerWriteQueryPerSecond");
        }
    }

    MetricsRegionServer(MetricsRegionServerWrapper regionServerWrapper, MetricsRegionServerSource serverSource, RegionServerTableMetrics tableMetrics, MetricsTable metricsTable, MetricsUserAggregate userAggregate) {
        this.regionServerWrapper = regionServerWrapper;
        this.serverSource = serverSource;
        this.tableMetrics = tableMetrics;
        this.metricsTable = metricsTable;
        this.userAggregate = userAggregate;
    }

    static RegionServerTableMetrics createTableMetrics(Configuration conf) {
        if (conf.getBoolean(RS_ENABLE_TABLE_METRICS_KEY, true)) {
            return new RegionServerTableMetrics(conf.getBoolean(RS_ENABLE_TABLE_QUERY_METER_METRICS_KEY, true));
        }
        return null;
    }

    public MetricsRegionServerSource getMetricsSource() {
        return this.serverSource;
    }

    public MetricsUserAggregate getMetricsUserAggregate() {
        return this.userAggregate;
    }

    public MetricsRegionServerWrapper getRegionServerWrapper() {
        return this.regionServerWrapper;
    }

    public void updatePutBatch(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updatePutBatch(tn, t);
        }
        this.serverSource.updatePutBatch(t);
    }

    public void updatePut(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updatePut(tn, t);
        }
        if (t > this.slowMetricTime) {
            this.serverSource.incrSlowPut();
        }
        this.serverSource.updatePut(t);
        this.userAggregate.updatePut(t);
    }

    public void updateDelete(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateDelete(tn, t);
        }
        if (t > this.slowMetricTime) {
            this.serverSource.incrSlowDelete();
        }
        this.serverSource.updateDelete(t);
        this.userAggregate.updateDelete(t);
    }

    public void updateDeleteBatch(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateDeleteBatch(tn, t);
        }
        this.serverSource.updateDeleteBatch(t);
    }

    public void updateCheckAndDelete(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateCheckAndDelete(tn, t);
        }
        this.serverSource.updateCheckAndDelete(t);
    }

    public void updateCheckAndPut(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateCheckAndPut(tn, t);
        }
        this.serverSource.updateCheckAndPut(t);
    }

    public void updateCheckAndMutate(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateCheckAndMutate(tn, t);
        }
        this.serverSource.updateCheckAndMutate(t);
    }

    public void updateGet(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateGet(tn, t);
        }
        if (t > this.slowMetricTime) {
            this.serverSource.incrSlowGet();
        }
        this.serverSource.updateGet(t);
        this.userAggregate.updateGet(t);
    }

    public void updateIncrement(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateIncrement(tn, t);
        }
        if (t > this.slowMetricTime) {
            this.serverSource.incrSlowIncrement();
        }
        this.serverSource.updateIncrement(t);
        this.userAggregate.updateIncrement(t);
    }

    public void updateAppend(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateAppend(tn, t);
        }
        if (t > this.slowMetricTime) {
            this.serverSource.incrSlowAppend();
        }
        this.serverSource.updateAppend(t);
        this.userAggregate.updateAppend(t);
    }

    public void updateReplay(long t) {
        this.serverSource.updateReplay(t);
        this.userAggregate.updateReplay(t);
    }

    public void updateScanSize(TableName tn, long scanSize) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateScanSize(tn, scanSize);
        }
        this.serverSource.updateScanSize(scanSize);
    }

    public void updateScanTime(TableName tn, long t) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateScanTime(tn, t);
        }
        this.serverSource.updateScanTime(t);
        this.userAggregate.updateScanTime(t);
    }

    public void updateSplitTime(long t) {
        this.serverSource.updateSplitTime(t);
    }

    public void incrSplitRequest() {
        this.serverSource.incrSplitRequest();
    }

    public void incrSplitSuccess() {
        this.serverSource.incrSplitSuccess();
    }

    public void updateFlush(String table, long t, long memstoreSize, long fileSize) {
        this.serverSource.updateFlushTime(t);
        this.serverSource.updateFlushMemStoreSize(memstoreSize);
        this.serverSource.updateFlushOutputSize(fileSize);
        if (table != null) {
            this.metricsTable.updateFlushTime(table, t);
            this.metricsTable.updateFlushMemstoreSize(table, memstoreSize);
            this.metricsTable.updateFlushOutputSize(table, fileSize);
        }
    }

    public void updateCompaction(String table, boolean isMajor, long t, int inputFileCount, int outputFileCount, long inputBytes, long outputBytes) {
        this.serverSource.updateCompactionTime(isMajor, t);
        this.serverSource.updateCompactionInputFileCount(isMajor, inputFileCount);
        this.serverSource.updateCompactionOutputFileCount(isMajor, outputFileCount);
        this.serverSource.updateCompactionInputSize(isMajor, inputBytes);
        this.serverSource.updateCompactionOutputSize(isMajor, outputBytes);
        if (table != null) {
            this.metricsTable.updateCompactionTime(table, isMajor, t);
            this.metricsTable.updateCompactionInputFileCount(table, isMajor, inputFileCount);
            this.metricsTable.updateCompactionOutputFileCount(table, isMajor, outputFileCount);
            this.metricsTable.updateCompactionInputSize(table, isMajor, inputBytes);
            this.metricsTable.updateCompactionOutputSize(table, isMajor, outputBytes);
        }
    }

    public void updateBulkLoad(long millis) {
        this.bulkLoadTimer.updateMillis(millis);
    }

    public void updateReadQueryMeter(TableName tn, long count) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateTableReadQueryMeter(tn, count);
        }
        if (this.serverReadQueryMeter != null) {
            this.serverReadQueryMeter.mark(count);
        }
    }

    public void updateWriteQueryMeter(TableName tn, long count) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateTableWriteQueryMeter(tn, count);
        }
        if (this.serverWriteQueryMeter != null) {
            this.serverWriteQueryMeter.mark(count);
        }
    }

    public void updateWriteQueryMeter(TableName tn) {
        if (this.tableMetrics != null && tn != null) {
            this.tableMetrics.updateTableWriteQueryMeter(tn);
        }
        if (this.serverWriteQueryMeter != null) {
            this.serverWriteQueryMeter.mark();
        }
    }

    public void incrementNumRegionSizeReportsSent(long numReportsSent) {
        this.quotaSource.incrementNumRegionSizeReportsSent(numReportsSent);
    }

    public void incrementRegionSizeReportingChoreTime(long time) {
        this.quotaSource.incrementRegionSizeReportingChoreTime(time);
    }
}

