/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.security.access.GlobalPermission;
import org.apache.hadoop.hbase.security.access.NamespacePermission;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.VersionedWritable;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class Permission
extends VersionedWritable {
    protected static final byte VERSION = 0;
    private static final Logger LOG = LoggerFactory.getLogger(Permission.class);
    protected static final Map<Byte, Action> ACTION_BY_CODE = ImmutableMap.of(Action.access$000(Action.READ), Action.READ, Action.access$000(Action.WRITE), Action.WRITE, Action.access$000(Action.EXEC), Action.EXEC, Action.access$000(Action.CREATE), Action.CREATE, Action.access$000(Action.ADMIN), Action.ADMIN);
    protected static final Map<Byte, Scope> SCOPE_BY_CODE = ImmutableMap.of(Scope.access$100(Scope.GLOBAL), Scope.GLOBAL, Scope.access$100(Scope.NAMESPACE), Scope.NAMESPACE, Scope.access$100(Scope.TABLE), Scope.TABLE, Scope.access$100(Scope.EMPTY), Scope.EMPTY);
    protected EnumSet<Action> actions = EnumSet.noneOf(Action.class);
    protected Scope scope = Scope.EMPTY;

    public Permission() {
    }

    public Permission(Action ... assigned) {
        if (assigned != null && assigned.length > 0) {
            this.actions.addAll(Arrays.asList(assigned));
        }
    }

    public Permission(byte[] actionCodes) {
        if (actionCodes != null) {
            for (byte code : actionCodes) {
                Action action = ACTION_BY_CODE.get(code);
                if (action == null) {
                    LOG.error("Ignoring unknown action code '" + Bytes.toStringBinary(new byte[]{code}) + "'");
                    continue;
                }
                this.actions.add(action);
            }
        }
    }

    public Action[] getActions() {
        return this.actions.toArray(new Action[this.actions.size()]);
    }

    public boolean implies(Action action) {
        return this.actions.contains((Object)action);
    }

    public void setActions(Action[] assigned) {
        if (assigned != null && assigned.length > 0) {
            this.actions.clear();
            this.actions.addAll(Arrays.asList(assigned));
        }
    }

    public boolean equalsExceptActions(Object obj) {
        return obj instanceof Permission;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)((Object)obj);
        if (this.actions.isEmpty() && other.actions.isEmpty()) {
            return true;
        }
        if (!this.actions.isEmpty() && !other.actions.isEmpty()) {
            if (this.actions.size() != other.actions.size()) {
                return false;
            }
            return this.actions.containsAll(other.actions);
        }
        return false;
    }

    public int hashCode() {
        int prime = 37;
        int result = 23;
        for (Action a : this.actions) {
            result = 37 * result + a.code();
        }
        result = 37 * result + this.scope.code();
        return result;
    }

    public String toString() {
        return "[Permission: " + this.rawExpression() + "]";
    }

    protected String rawExpression() {
        StringBuilder raw = new StringBuilder("actions=");
        if (this.actions != null) {
            int i = 0;
            for (Action action : this.actions) {
                if (i > 0) {
                    raw.append(",");
                }
                raw.append(action != null ? action.toString() : "NULL");
                ++i;
            }
        }
        return raw.toString();
    }

    public byte getVersion() {
        return 0;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int length = in.readByte();
        this.actions = EnumSet.noneOf(Action.class);
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                byte b = in.readByte();
                Action action = ACTION_BY_CODE.get(b);
                if (action == null) {
                    throw new IOException("Unknown action code '" + Bytes.toStringBinary(new byte[]{b}) + "' in input");
                }
                this.actions.add(action);
            }
        }
        this.scope = SCOPE_BY_CODE.get(in.readByte());
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeByte(this.actions != null ? this.actions.size() : 0);
        if (this.actions != null) {
            for (Action a : this.actions) {
                out.writeByte(a.code());
            }
        }
        out.writeByte(this.scope.code());
    }

    public Scope getAccessScope() {
        return this.scope;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String namespace) {
        return new Builder(namespace);
    }

    public static Builder newBuilder(TableName tableName) {
        return new Builder(tableName);
    }

    public static final class Builder {
        private String namespace;
        private TableName tableName;
        private byte[] family;
        private byte[] qualifier;
        private List<Action> actions = new ArrayList<Action>();

        private Builder() {
        }

        private Builder(String namespace) {
            this.namespace = namespace;
        }

        private Builder(TableName tableName) {
            this.tableName = tableName;
        }

        public Builder withFamily(byte[] family) {
            Objects.requireNonNull(this.tableName, "The tableName can't be NULL");
            this.family = family;
            return this;
        }

        public Builder withQualifier(byte[] qualifier) {
            Objects.requireNonNull(this.tableName, "The tableName can't be NULL");
            this.qualifier = qualifier;
            return this;
        }

        public Builder withActions(Action ... actions) {
            for (Action action : actions) {
                if (action == null) continue;
                this.actions.add(action);
            }
            return this;
        }

        public Builder withActionCodes(byte[] actionCodes) {
            if (actionCodes != null) {
                for (byte code : actionCodes) {
                    Action action = ACTION_BY_CODE.get(code);
                    if (action == null) {
                        LOG.error("Ignoring unknown action code '{}'", (Object)Bytes.toStringBinary(new byte[]{code}));
                        continue;
                    }
                    this.actions.add(action);
                }
            }
            return this;
        }

        public Permission build() {
            Action[] actionArray = this.actions.toArray(new Action[this.actions.size()]);
            if (this.namespace != null) {
                return new NamespacePermission(this.namespace, actionArray);
            }
            if (this.tableName != null) {
                return new TablePermission(this.tableName, this.family, this.qualifier, actionArray);
            }
            return new GlobalPermission(actionArray);
        }
    }

    @InterfaceAudience.Private
    protected static enum Scope {
        GLOBAL('G'),
        NAMESPACE('N'),
        TABLE('T'),
        EMPTY('E');

        private final byte code;

        private Scope(char code) {
            this.code = (byte)code;
        }

        public byte code() {
            return this.code;
        }

        static /* synthetic */ byte access$100(Scope x0) {
            return x0.code;
        }
    }

    @InterfaceAudience.Public
    public static enum Action {
        READ('R'),
        WRITE('W'),
        EXEC('X'),
        CREATE('C'),
        ADMIN('A');

        private final byte code;

        private Action(char code) {
            this.code = (byte)code;
        }

        public byte code() {
            return this.code;
        }

        static /* synthetic */ byte access$000(Action x0) {
            return x0.code;
        }
    }
}

