/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsCache;
import org.apache.hadoop.hbase.zookeeper.ZKListener;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ZKVisibilityLabelWatcher
extends ZKListener {
    private static final Logger LOG = LoggerFactory.getLogger(ZKVisibilityLabelWatcher.class);
    private static final String VISIBILITY_LABEL_ZK_PATH = "zookeeper.znode.visibility.label.parent";
    private static final String DEFAULT_VISIBILITY_LABEL_NODE = "visibility/labels";
    private static final String VISIBILITY_USER_AUTHS_ZK_PATH = "zookeeper.znode.visibility.user.auths.parent";
    private static final String DEFAULT_VISIBILITY_USER_AUTHS_NODE = "visibility/user_auths";
    private VisibilityLabelsCache labelsCache;
    private String labelZnode;
    private String userAuthsZnode;

    public ZKVisibilityLabelWatcher(ZKWatcher watcher, VisibilityLabelsCache labelsCache, Configuration conf) {
        super(watcher);
        this.labelsCache = labelsCache;
        String labelZnodeParent = conf.get(VISIBILITY_LABEL_ZK_PATH, DEFAULT_VISIBILITY_LABEL_NODE);
        String userAuthsZnodeParent = conf.get(VISIBILITY_USER_AUTHS_ZK_PATH, DEFAULT_VISIBILITY_USER_AUTHS_NODE);
        this.labelZnode = ZNodePaths.joinZNode(watcher.getZNodePaths().baseZNode, labelZnodeParent);
        this.userAuthsZnode = ZNodePaths.joinZNode(watcher.getZNodePaths().baseZNode, userAuthsZnodeParent);
    }

    public void start() throws KeeperException {
        this.watcher.registerListener((ZKListener)this);
        ZKUtil.createWithParents((ZKWatcher)this.watcher, (String)this.labelZnode);
        ZKUtil.createWithParents((ZKWatcher)this.watcher, (String)this.userAuthsZnode);
        byte[] data = ZKUtil.getDataAndWatch((ZKWatcher)this.watcher, (String)this.labelZnode);
        if (data != null && data.length > 0) {
            this.refreshVisibilityLabelsCache(data);
        }
        if ((data = ZKUtil.getDataAndWatch((ZKWatcher)this.watcher, (String)this.userAuthsZnode)) != null && data.length > 0) {
            this.refreshUserAuthsCache(data);
        }
    }

    private void refreshVisibilityLabelsCache(byte[] data) {
        try {
            this.labelsCache.refreshLabelsCache(data);
        }
        catch (IOException ioe) {
            LOG.error("Failed parsing data from labels table  from zk", (Throwable)ioe);
        }
    }

    private void refreshUserAuthsCache(byte[] data) {
        try {
            this.labelsCache.refreshUserAuthsCache(data);
        }
        catch (IOException ioe) {
            LOG.error("Failed parsing data from labels table  from zk", (Throwable)ioe);
        }
    }

    public void nodeCreated(String path) {
        if (path.equals(this.labelZnode) || path.equals(this.userAuthsZnode)) {
            try {
                ZKUtil.watchAndCheckExists((ZKWatcher)this.watcher, (String)path);
            }
            catch (KeeperException ke) {
                LOG.error("Error setting watcher on node " + path, (Throwable)ke);
                this.watcher.abort("ZooKeeper error obtaining label node children", (Throwable)ke);
            }
        }
    }

    public void nodeDeleted(String path) {
    }

    public void nodeDataChanged(String path) {
        if (path.equals(this.labelZnode) || path.equals(this.userAuthsZnode)) {
            try {
                this.watcher.syncOrTimeout(path);
                byte[] data = ZKUtil.getDataAndWatch((ZKWatcher)this.watcher, (String)path);
                if (path.equals(this.labelZnode)) {
                    this.refreshVisibilityLabelsCache(data);
                } else {
                    this.refreshUserAuthsCache(data);
                }
            }
            catch (KeeperException ke) {
                LOG.error("Error reading data from zookeeper for node " + path, (Throwable)ke);
                this.watcher.abort("ZooKeeper error getting data for node " + path, (Throwable)ke);
            }
        }
    }

    public void nodeChildrenChanged(String path) {
    }

    public void writeToZookeeper(byte[] data, boolean labelsOrUserAuths) {
        String znode = this.labelZnode;
        if (!labelsOrUserAuths) {
            znode = this.userAuthsZnode;
        }
        try {
            ZKUtil.updateExistingNodeData((ZKWatcher)this.watcher, (String)znode, (byte[])data, (int)-1);
        }
        catch (KeeperException e) {
            LOG.error("Failed writing to " + znode, (Throwable)e);
            this.watcher.abort("Failed writing node " + znode + " to zookeeper", (Throwable)e);
        }
    }
}

