/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.master;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.RSGroupTableAccessor;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.tmpl.master.RSGroupListTmpl;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class RSGroupListTmplImpl
extends AbstractTemplateImpl
implements RSGroupListTmpl.Intf {
    private final HMaster master;
    private final ServerManager serverManager;

    protected static RSGroupListTmpl.ImplData __jamon_setOptionalArguments(RSGroupListTmpl.ImplData p_implData) {
        return p_implData;
    }

    public RSGroupListTmplImpl(TemplateManager p_templateManager, RSGroupListTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)RSGroupListTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.master = p_implData.getMaster();
        this.serverManager = p_implData.getServerManager();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        List<RSGroupInfo> groups = RSGroupTableAccessor.getAllRSGroupInfo(this.master.getConnection());
        if (groups != null && groups.size() > 0) {
            jamonWriter.write("\n\n");
            RSGroupInfo[] rsGroupInfos = groups.toArray(new RSGroupInfo[groups.size()]);
            Map<Address, ServerMetrics> collectServers = Collections.emptyMap();
            if (this.master.getServerManager() != null) {
                collectServers = this.master.getServerManager().getOnlineServers().entrySet().stream().collect(Collectors.toMap(p -> ((ServerName)p.getKey()).getAddress(), Map.Entry::getValue));
            }
            jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_rsgroup_baseStats\" data-toggle=\"tab\">Base Stats</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_memoryStats\" data-toggle=\"tab\">Memory</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_requestStats\" data-toggle=\"tab\">Requests</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_storeStats\" data-toggle=\"tab\">Storefiles</a></li>\n        <li class=\"\"><a href=\"#tab_rsgroup_compactStats\" data-toggle=\"tab\">Compactions</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_rsgroup_baseStats\">\n            ");
            this.__jamon_innerUnit__rsgroup_baseStats(jamonWriter, rsGroupInfos, collectServers);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_memoryStats\">\n            ");
            this.__jamon_innerUnit__rsgroup_memoryStats(jamonWriter, rsGroupInfos, collectServers);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_requestStats\">\n            ");
            this.__jamon_innerUnit__rsgroup_requestStats(jamonWriter, rsGroupInfos, collectServers);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_storeStats\">\n            ");
            this.__jamon_innerUnit__rsgroup_storeStats(jamonWriter, rsGroupInfos, collectServers);
            jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_rsgroup_compactStats\">\n            ");
            this.__jamon_innerUnit__rsgroup_compactStats(jamonWriter, rsGroupInfos, collectServers);
            jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
        }
        jamonWriter.write("\n\n");
    }

    private void __jamon_innerUnit__rsGroupLink(Writer jamonWriter, String rsGroupName) throws IOException {
        jamonWriter.write("<a href=rsgroup.jsp?name=");
        Escaping.HTML.write(StandardEmitter.valueOf((String)rsGroupName), jamonWriter);
        jamonWriter.write(">");
        Escaping.HTML.write(StandardEmitter.valueOf((String)rsGroupName), jamonWriter);
        jamonWriter.write("</a>\n");
    }

    private void __jamon_innerUnit__rsgroup_baseStats(Writer jamonWriter, RSGroupInfo[] rsGroupInfos, Map<Address, ServerMetrics> collectServers) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Online Servers</th>\n    <th>Num. Dead Servers</th>\n    <th>Num. Tables</th>\n    <th>Requests Per Second</th>\n    <th>Num. Regions</th>\n    <th>Average Load</th>\n</tr>\n");
        int totalOnlineServers = 0;
        int totalDeadServers = 0;
        int totalTables = 0;
        int totalRequests = 0;
        int totalRegions = 0;
        for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
            String rsGroupName = rsGroupInfo.getName();
            int onlineServers = 0;
            int deadServers = 0;
            int tables = 0;
            long requestsPerSecond = 0L;
            int numRegionsOnline = 0;
            Set<Address> servers = rsGroupInfo.getServers();
            for (Address server : servers) {
                ServerMetrics sl = collectServers.get(server);
                if (sl != null) {
                    requestsPerSecond += sl.getRequestCountPerSecond();
                    numRegionsOnline += sl.getRegionMetrics().size();
                    totalRegions += sl.getRegionMetrics().size();
                    totalRequests = (int)((long)totalRequests + sl.getRequestCountPerSecond());
                    ++totalOnlineServers;
                    ++onlineServers;
                    continue;
                }
                ++totalDeadServers;
                ++deadServers;
            }
            tables = rsGroupInfo.getTables().size();
            totalTables += tables;
            double avgLoad = onlineServers == 0 ? 0.0 : (double)numRegionsOnline / (double)onlineServers;
            jamonWriter.write("<tr>\n    <td>");
            this.__jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)onlineServers), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)deadServers), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)tables), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)requestsPerSecond), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)numRegionsOnline), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.limitDecimalTo2((double)avgLoad)), jamonWriter);
            jamonWriter.write("</td>\n</tr>\n");
        }
        jamonWriter.write("<tr><td>Total:");
        Escaping.HTML.write(StandardEmitter.valueOf((int)rsGroupInfos.length), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)totalOnlineServers), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)totalDeadServers), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)totalTables), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)totalRequests), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((int)totalRegions), jamonWriter);
        jamonWriter.write("</td>\n<td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.limitDecimalTo2((double)this.master.getServerManager().getAverageLoad())), jamonWriter);
        jamonWriter.write("</td>\n</tr>\n</table>\n");
    }

    private void __jamon_innerUnit__rsgroup_compactStats(Writer jamonWriter, RSGroupInfo[] rsGroupInfos, Map<Address, ServerMetrics> collectServers) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Compacting Cells</th>\n    <th>Num. Compacted Cells</th>\n    <th>Remaining Cells</th>\n    <th>Compaction Progress</th>\n</tr>\n");
        for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
            String rsGroupName = rsGroupInfo.getName();
            boolean numStores = false;
            long totalCompactingCells = 0L;
            long totalCompactedCells = 0L;
            long remainingCells = 0L;
            long compactionProgress = 0L;
            for (Address server : rsGroupInfo.getServers()) {
                ServerMetrics sl = collectServers.get(server);
                if (sl == null) continue;
                for (RegionMetrics rl : sl.getRegionMetrics().values()) {
                    totalCompactingCells += rl.getCompactingCellCount();
                    totalCompactedCells += rl.getCompactedCellCount();
                }
            }
            remainingCells = totalCompactingCells - totalCompactedCells;
            String percentDone = "";
            if (totalCompactingCells > 0L) {
                percentDone = String.format("%.2f", Float.valueOf(100.0f * ((float)totalCompactedCells / (float)totalCompactingCells))) + "%";
            }
            jamonWriter.write("<tr>\n<td>");
            this.__jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)totalCompactingCells), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)totalCompactedCells), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)remainingCells), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)percentDone), jamonWriter);
            jamonWriter.write("</td>\n</tr>\n");
        }
        jamonWriter.write("</table>\n");
    }

    private void __jamon_innerUnit__rsgroup_memoryStats(Writer jamonWriter, RSGroupInfo[] rsGroupInfos, Map<Address, ServerMetrics> collectServers) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Used Heap</th>\n    <th>Max Heap</th>\n    <th>Memstore Size</th>\n\n</tr>\n");
        String ZEROMB = "0 MB";
        for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
            String usedHeapStr = "0 MB";
            String maxHeapStr = "0 MB";
            String memstoreSizeStr = "0 MB";
            String rsGroupName = rsGroupInfo.getName();
            long usedHeap = 0L;
            long maxHeap = 0L;
            long memstoreSize = 0L;
            for (Address server : rsGroupInfo.getServers()) {
                ServerMetrics sl = collectServers.get(server);
                if (sl == null) continue;
                usedHeap += (long)sl.getUsedHeapSize().get(Size.Unit.MEGABYTE);
                maxHeap += (long)sl.getMaxHeapSize().get(Size.Unit.MEGABYTE);
                memstoreSize += (long)sl.getRegionMetrics().values().stream().mapToDouble(rm -> rm.getMemStoreSize().get(Size.Unit.MEGABYTE)).sum();
            }
            if (usedHeap > 0L) {
                usedHeapStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(usedHeap * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
            }
            if (maxHeap > 0L) {
                maxHeapStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(maxHeap * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
            }
            if (memstoreSize > 0L) {
                memstoreSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(memstoreSize * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
            }
            jamonWriter.write("<tr>\n    <td>");
            this.__jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)usedHeapStr), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)maxHeapStr), jamonWriter);
            jamonWriter.write("</td>\n    <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)memstoreSizeStr), jamonWriter);
            jamonWriter.write("</td>\n\n</tr>\n");
        }
        jamonWriter.write("</table>\n");
    }

    private void __jamon_innerUnit__rsgroup_requestStats(Writer jamonWriter, RSGroupInfo[] rsGroupInfos, Map<Address, ServerMetrics> collectServers) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Request Per Second</th>\n    <th>Read Request Count</th>\n    <th>Write Request Count</th>\n</tr>\n");
        for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
            String rsGroupName = rsGroupInfo.getName();
            long requestsPerSecond = 0L;
            long readRequests = 0L;
            long writeRequests = 0L;
            for (Address server : rsGroupInfo.getServers()) {
                ServerMetrics sl = collectServers.get(server);
                if (sl == null) continue;
                for (RegionMetrics rm : sl.getRegionMetrics().values()) {
                    readRequests += rm.getReadRequestCount();
                    writeRequests += rm.getWriteRequestCount();
                }
                requestsPerSecond += sl.getRequestCountPerSecond();
            }
            jamonWriter.write("<tr>\n<td>");
            this.__jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)requestsPerSecond), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)readRequests), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)writeRequests), jamonWriter);
            jamonWriter.write("</td>\n</tr>\n");
        }
        jamonWriter.write("</table>\n");
    }

    private void __jamon_innerUnit__rsgroup_storeStats(Writer jamonWriter, RSGroupInfo[] rsGroupInfos, Map<Address, ServerMetrics> collectServers) throws IOException {
        jamonWriter.write("<table class=\"table table-striped\">\n<tr>\n    <th>RSGroup Name</th>\n    <th>Num. Stores</th>\n    <th>Num. Storefiles</th>\n    <th>Storefile Size Uncompressed</th>\n    <th>Storefile Size</th>\n    <th>Index Size</th>\n    <th>Bloom Size</th>\n</tr>\n");
        String ZEROKB = "0 KB";
        String ZEROMB = "0 MB";
        for (RSGroupInfo rsGroupInfo : rsGroupInfos) {
            String uncompressedStorefileSizeStr = "0 MB";
            String storefileSizeStr = "0 MB";
            String indexSizeStr = "0 KB";
            String bloomSizeStr = "0 KB";
            String rsGroupName = rsGroupInfo.getName();
            int numStores = 0;
            long numStorefiles = 0L;
            long uncompressedStorefileSize = 0L;
            long storefileSize = 0L;
            long indexSize = 0L;
            long bloomSize = 0L;
            int count = 0;
            for (Address server : rsGroupInfo.getServers()) {
                ServerMetrics sl = collectServers.get(server);
                if (sl == null) continue;
                for (RegionMetrics rm : sl.getRegionMetrics().values()) {
                    numStores += rm.getStoreCount();
                    numStorefiles += (long)rm.getStoreFileCount();
                    uncompressedStorefileSize = (long)((double)uncompressedStorefileSize + rm.getUncompressedStoreFileSize().get(Size.Unit.MEGABYTE));
                    storefileSize = (long)((double)storefileSize + rm.getStoreFileSize().get(Size.Unit.MEGABYTE));
                    indexSize = (long)((double)indexSize + rm.getStoreFileUncompressedDataIndexSize().get(Size.Unit.KILOBYTE));
                    bloomSize = (long)((double)bloomSize + rm.getBloomFilterSize().get(Size.Unit.KILOBYTE));
                }
                ++count;
            }
            if (uncompressedStorefileSize > 0L) {
                uncompressedStorefileSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(uncompressedStorefileSize * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
            }
            if (storefileSize > 0L) {
                storefileSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(storefileSize * StringUtils.TraditionalBinaryPrefix.MEGA.value), (String)"B", (int)1);
            }
            if (indexSize > 0L) {
                indexSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(indexSize * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1);
            }
            if (bloomSize > 0L) {
                bloomSizeStr = StringUtils.TraditionalBinaryPrefix.long2String((long)(bloomSize * StringUtils.TraditionalBinaryPrefix.KILO.value), (String)"B", (int)1);
            }
            jamonWriter.write("<tr>\n<td>");
            this.__jamon_innerUnit__rsGroupLink(jamonWriter, rsGroupName);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((int)numStores), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)numStorefiles), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)uncompressedStorefileSizeStr), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)storefileSizeStr), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)indexSizeStr), jamonWriter);
            jamonWriter.write("</td>\n<td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)bloomSizeStr), jamonWriter);
            jamonWriter.write("</td>\n</tr>\n");
        }
        jamonWriter.write("</table>\n");
    }
}

