/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.processors;

import io.hops.hudi.org.apache.avro.LogicalTypes;
import io.hops.hudi.org.apache.avro.Schema;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Base64;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.processors.JsonFieldProcessor;
import org.apache.hudi.common.util.collection.Pair;

public abstract class DecimalLogicalTypeProcessor
extends JsonFieldProcessor {
    protected static boolean isValidDecimalTypeConfig(Schema schema) {
        LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
        if (decimalType == null) {
            return false;
        }
        decimalType.validate(schema);
        return true;
    }

    protected static Pair<Boolean, BigDecimal> parseObjectToBigDecimal(Object obj, Schema schema) {
        BigDecimal bigDecimal = null;
        LogicalTypes.Decimal logicalType = (LogicalTypes.Decimal)schema.getLogicalType();
        try {
            if (obj instanceof BigDecimal) {
                bigDecimal = ((BigDecimal)obj).setScale(logicalType.getScale(), RoundingMode.UNNECESSARY);
            } else if (obj instanceof String) {
                try {
                    bigDecimal = HoodieAvroUtils.convertBytesToBigDecimal(DecimalLogicalTypeProcessor.decodeStringToBigDecimalBytes(obj), (LogicalTypes.Decimal)schema.getLogicalType());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (bigDecimal == null) {
                bigDecimal = new BigDecimal(obj.toString(), new MathContext(logicalType.getPrecision(), RoundingMode.UNNECESSARY)).setScale(logicalType.getScale(), RoundingMode.UNNECESSARY);
            }
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            // empty catch block
        }
        if (bigDecimal == null) {
            return Pair.of(false, null);
        }
        LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
        if (bigDecimal.scale() > decimalType.getScale() || bigDecimal.precision() - bigDecimal.scale() > decimalType.getPrecision() - decimalType.getScale()) {
            return Pair.of(false, null);
        }
        return Pair.of(true, bigDecimal);
    }

    protected static byte[] decodeStringToBigDecimalBytes(Object value) {
        return Base64.getDecoder().decode(((String)value).getBytes());
    }
}

