/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import io.hops.hudi.org.apache.avro.Schema;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.clustering.run.strategy.JavaExecutionStrategy;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.JavaBulkInsertHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSortAndSizeExecutionStrategy<T>
extends JavaExecutionStrategy<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaSortAndSizeExecutionStrategy.class);

    public JavaSortAndSizeExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    public List<WriteStatus> performClusteringWithRecordList(List<HoodieRecord<T>> inputRecords, int numOutputGroups, String instantTime, Map<String, String> strategyParams, Schema schema, List<HoodieFileGroupId> fileGroupIdList, boolean preserveHoodieMetadata) {
        LOG.info("Starting clustering for a group, parallelism:" + numOutputGroups + " commit:" + instantTime);
        HoodieWriteConfig newConfig = HoodieWriteConfig.newBuilder().withBulkInsertParallelism(numOutputGroups).withEngineType(EngineType.JAVA).withProps(this.getWriteConfig().getProps()).build();
        newConfig.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE, String.valueOf(this.getWriteConfig().getClusteringTargetFileMaxBytes()));
        return JavaBulkInsertHelper.newInstance().bulkInsert(inputRecords, instantTime, this.getHoodieTable(), newConfig, false, this.getPartitioner(strategyParams, schema), true, numOutputGroups, (WriteHandleFactory)new CreateHandleFactory(preserveHoodieMetadata));
    }
}

