/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import io.hops.hudi.org.apache.avro.Schema;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.BaseHoodieLogRecordReader;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordReader;
import org.apache.hudi.common.table.read.FileGroupReaderSchemaHandler;
import org.apache.hudi.common.table.read.FileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.PositionBasedFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.PositionBasedSchemaHandler;
import org.apache.hudi.common.table.read.UnmergedFileGroupRecordBuffer;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.CachingIterator;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.EmptyIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.common.util.collection.Triple;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public final class HoodieFileGroupReader<T>
implements Closeable {
    private final HoodieReaderContext<T> readerContext;
    private final Option<HoodieBaseFile> hoodieBaseFileOption;
    private final List<HoodieLogFile> logFiles;
    private final HoodieStorage storage;
    private final TypedProperties props;
    private final long start;
    private final long length;
    private final FileGroupRecordBuffer<T> recordBuffer;
    private ClosableIterator<T> baseFileIterator;
    private final Option<UnaryOperator<T>> outputConverter;
    private final HoodieReadStats readStats;
    private boolean allowInflightInstants;

    public HoodieFileGroupReader(HoodieReaderContext<T> readerContext, HoodieStorage storage, String tablePath, String latestCommitTime, FileSlice fileSlice, Schema dataSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, HoodieTableMetaClient hoodieTableMetaClient, TypedProperties props, long start, long length, boolean shouldUseRecordPosition) {
        this(readerContext, storage, tablePath, latestCommitTime, fileSlice, dataSchema, requestedSchema, internalSchemaOpt, hoodieTableMetaClient, props, start, length, shouldUseRecordPosition, false);
    }

    public HoodieFileGroupReader(HoodieReaderContext<T> readerContext, HoodieStorage storage, String tablePath, String latestCommitTime, FileSlice fileSlice, Schema dataSchema, Schema requestedSchema, Option<InternalSchema> internalSchemaOpt, HoodieTableMetaClient hoodieTableMetaClient, TypedProperties props, long start, long length, boolean shouldUseRecordPosition, boolean allowInflightInstants) {
        this.readerContext = readerContext;
        this.storage = storage;
        this.hoodieBaseFileOption = fileSlice.getBaseFile();
        this.logFiles = fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList());
        this.props = props;
        this.start = start;
        this.length = length;
        HoodieTableConfig tableConfig = hoodieTableMetaClient.getTableConfig();
        RecordMergeMode recordMergeMode = tableConfig.getRecordMergeMode();
        String mergeStrategyId = tableConfig.getRecordMergeStrategyId();
        if (!tableConfig.getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
            Triple<RecordMergeMode, String, String> triple = HoodieTableConfig.inferCorrectMergingBehavior(recordMergeMode, tableConfig.getPayloadClass(), mergeStrategyId, null, tableConfig.getTableVersion());
            recordMergeMode = triple.getLeft();
            mergeStrategyId = triple.getRight();
        }
        readerContext.setRecordMerger(readerContext.getRecordMerger(recordMergeMode, mergeStrategyId, props.getString("hoodie.write.record.merge.custom.implementation.classes", props.getString("hoodie.datasource.write.record.merger.impls", ""))));
        readerContext.setTablePath(tablePath);
        readerContext.setLatestCommitTime(latestCommitTime);
        boolean isSkipMerge = ConfigUtils.getStringWithAltKeys((Properties)props, HoodieReaderConfig.MERGE_TYPE, true).equalsIgnoreCase("skip_merge");
        readerContext.setShouldMergeUseRecordPosition(shouldUseRecordPosition && !isSkipMerge);
        readerContext.setHasLogFiles(!this.logFiles.isEmpty());
        if (readerContext.getHasLogFiles() && start != 0L) {
            throw new IllegalArgumentException("Filegroup reader is doing log file merge but not reading from the start of the base file");
        }
        readerContext.setHasBootstrapBaseFile(this.hoodieBaseFileOption.isPresent() && this.hoodieBaseFileOption.get().getBootstrapBaseFile().isPresent());
        readerContext.setSchemaHandler(readerContext.supportsParquetRowIndex() ? new PositionBasedSchemaHandler<T>(readerContext, dataSchema, requestedSchema, internalSchemaOpt, tableConfig, props) : new FileGroupReaderSchemaHandler<T>(readerContext, dataSchema, requestedSchema, internalSchemaOpt, tableConfig, props));
        this.outputConverter = readerContext.getSchemaHandler().getOutputConverter();
        this.readStats = new HoodieReadStats();
        this.recordBuffer = HoodieFileGroupReader.getRecordBuffer(readerContext, hoodieTableMetaClient, recordMergeMode, props, this.hoodieBaseFileOption, this.logFiles.isEmpty(), isSkipMerge, shouldUseRecordPosition, this.readStats);
        this.allowInflightInstants = allowInflightInstants;
    }

    private static FileGroupRecordBuffer getRecordBuffer(HoodieReaderContext readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, TypedProperties props, Option<HoodieBaseFile> baseFileOption, boolean hasNoLogFiles, boolean isSkipMerge, boolean shouldUseRecordPosition, HoodieReadStats readStats) {
        if (hasNoLogFiles) {
            return null;
        }
        if (isSkipMerge) {
            return new UnmergedFileGroupRecordBuffer(readerContext, hoodieTableMetaClient, recordMergeMode, Option.empty(), Option.empty(), props, readStats);
        }
        if (shouldUseRecordPosition && baseFileOption.isPresent()) {
            return new PositionBasedFileGroupRecordBuffer(readerContext, hoodieTableMetaClient, recordMergeMode, Option.empty(), Option.empty(), baseFileOption.get().getCommitTime(), props, readStats);
        }
        return new KeyBasedFileGroupRecordBuffer(readerContext, hoodieTableMetaClient, recordMergeMode, Option.empty(), Option.empty(), props, readStats);
    }

    public void initRecordIterators() throws IOException {
        ClosableIterator<T> iter = this.makeBaseFileIterator();
        if (this.logFiles.isEmpty()) {
            this.baseFileIterator = CachingIterator.wrap(iter, this.readerContext);
        } else {
            this.baseFileIterator = iter;
            this.scanLogFiles();
            this.recordBuffer.setBaseFileIterator(this.baseFileIterator);
        }
    }

    private ClosableIterator<T> makeBaseFileIterator() throws IOException {
        if (!this.hoodieBaseFileOption.isPresent()) {
            return new EmptyIterator();
        }
        HoodieBaseFile baseFile = this.hoodieBaseFileOption.get();
        if (baseFile.getBootstrapBaseFile().isPresent()) {
            return this.makeBootstrapBaseFileIterator(baseFile);
        }
        StoragePathInfo baseFileStoragePathInfo = baseFile.getPathInfo();
        if (baseFileStoragePathInfo != null) {
            return this.readerContext.getFileRecordIterator(baseFileStoragePathInfo, this.start, this.length, this.readerContext.getSchemaHandler().getTableSchema(), this.readerContext.getSchemaHandler().getRequiredSchema(), this.storage);
        }
        return this.readerContext.getFileRecordIterator(baseFile.getStoragePath(), this.start, this.length, this.readerContext.getSchemaHandler().getTableSchema(), this.readerContext.getSchemaHandler().getRequiredSchema(), this.storage);
    }

    private ClosableIterator<T> makeBootstrapBaseFileIterator(HoodieBaseFile baseFile) throws IOException {
        BaseFile dataFile = baseFile.getBootstrapBaseFile().get();
        Pair<List<Schema.Field>, List<Schema.Field>> requiredFields = this.readerContext.getSchemaHandler().getBootstrapRequiredFields();
        Pair<List<Schema.Field>, List<Schema.Field>> allFields = this.readerContext.getSchemaHandler().getBootstrapDataFields();
        Option<Pair<ClosableIterator<T>, Schema>> dataFileIterator = this.makeBootstrapBaseFileIteratorHelper(requiredFields.getRight(), allFields.getRight(), dataFile);
        Option<Pair<ClosableIterator<T>, Schema>> skeletonFileIterator = this.makeBootstrapBaseFileIteratorHelper(requiredFields.getLeft(), allFields.getLeft(), baseFile);
        if (!dataFileIterator.isPresent() && !skeletonFileIterator.isPresent()) {
            throw new IllegalStateException("should not be here if only partition cols are required");
        }
        if (!dataFileIterator.isPresent()) {
            return skeletonFileIterator.get().getLeft();
        }
        if (!skeletonFileIterator.isPresent()) {
            return dataFileIterator.get().getLeft();
        }
        if (this.start != 0L) {
            throw new IllegalArgumentException("Filegroup reader is doing bootstrap merge but we are not reading from the start of the base file");
        }
        return this.readerContext.mergeBootstrapReaders(skeletonFileIterator.get().getLeft(), skeletonFileIterator.get().getRight(), dataFileIterator.get().getLeft(), dataFileIterator.get().getRight());
    }

    private Option<Pair<ClosableIterator<T>, Schema>> makeBootstrapBaseFileIteratorHelper(List<Schema.Field> requiredFields, List<Schema.Field> allFields, BaseFile file) throws IOException {
        if (requiredFields.isEmpty()) {
            return Option.empty();
        }
        Schema requiredSchema = this.readerContext.getSchemaHandler().createSchemaFromFields(requiredFields);
        StoragePathInfo fileStoragePathInfo = file.getPathInfo();
        if (fileStoragePathInfo != null) {
            return Option.of(Pair.of(this.readerContext.getFileRecordIterator(fileStoragePathInfo, 0L, file.getFileLen(), this.readerContext.getSchemaHandler().createSchemaFromFields(allFields), requiredSchema, this.storage), requiredSchema));
        }
        return Option.of(Pair.of(this.readerContext.getFileRecordIterator(file.getStoragePath(), 0L, file.getFileLen(), this.readerContext.getSchemaHandler().createSchemaFromFields(allFields), requiredSchema, this.storage), requiredSchema));
    }

    public boolean hasNext() throws IOException {
        if (this.recordBuffer == null) {
            return this.baseFileIterator.hasNext();
        }
        return this.recordBuffer.hasNext();
    }

    public HoodieReadStats getStats() {
        return this.readStats;
    }

    public T next() {
        Object nextVal;
        Object object = nextVal = this.recordBuffer == null ? this.baseFileIterator.next() : this.recordBuffer.next();
        if (this.outputConverter.isPresent()) {
            return (T)this.outputConverter.get().apply(nextVal);
        }
        return (T)nextVal;
    }

    private void scanLogFiles() {
        String path = this.readerContext.getTablePath();
        try (BaseHoodieLogRecordReader logRecordReader = ((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)((HoodieMergedLogRecordReader.Builder)HoodieMergedLogRecordReader.newBuilder().withHoodieReaderContext((HoodieReaderContext)this.readerContext)).withStorage(this.storage)).withLogFiles((List)this.logFiles)).withReverseReader(false)).withBufferSize(ConfigUtils.getIntWithAltKeys(this.props, HoodieMemoryConfig.MAX_DFS_STREAM_BUFFER_SIZE))).withPartition(FSUtils.getRelativePartitionPath(new StoragePath(path), this.logFiles.get(0).getPath().getParent()))).withRecordBuffer(this.recordBuffer).withAllowInflightInstants(this.allowInflightInstants).build();){
            this.readStats.setTotalLogReadTimeMs(((HoodieMergedLogRecordReader)logRecordReader).getTotalTimeTakenToReadAndMergeBlocks());
            this.readStats.setTotalUpdatedRecordsCompacted(((HoodieMergedLogRecordReader)logRecordReader).getNumMergedRecordsInLog());
            this.readStats.setTotalLogFilesCompacted(logRecordReader.getTotalLogFiles());
            this.readStats.setTotalLogRecords(logRecordReader.getTotalLogRecords());
            this.readStats.setTotalLogBlocks(logRecordReader.getTotalLogBlocks());
            this.readStats.setTotalCorruptLogBlock(logRecordReader.getTotalCorruptBlocks());
            this.readStats.setTotalRollbackBlocks(logRecordReader.getTotalRollbacks());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.baseFileIterator != null) {
            this.baseFileIterator.close();
        }
        if (this.recordBuffer != null) {
            this.recordBuffer.close();
        }
        if (this.readerContext != null) {
            this.readerContext.close();
        }
    }

    public HoodieFileGroupReaderIterator<T> getClosableIterator() {
        return new HoodieFileGroupReaderIterator(this);
    }

    public static class HoodieFileGroupReaderIterator<T>
    implements ClosableIterator<T> {
        private HoodieFileGroupReader<T> reader;

        public HoodieFileGroupReaderIterator(HoodieFileGroupReader<T> reader) {
            this.reader = reader;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to read record", e);
            }
        }

        @Override
        public T next() {
            return this.reader.next();
        }

        @Override
        public void close() {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to close the reader", e);
            }
            finally {
                this.reader = null;
            }
        }
    }
}

