/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import io.hops.hudi.org.apache.avro.generic.GenericRecord;
import java.io.IOException;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieMergeArchiveFilePlan;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.ArchivedTimelineLoader;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.ArchivedTimelineV1;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchivedTimelineLoaderV1
implements ArchivedTimelineLoader {
    private static final String MERGE_ARCHIVE_PLAN_NAME = "mergeArchivePlan";
    private static final Pattern ARCHIVE_FILE_PATTERN = Pattern.compile("^\\.commits_\\.archive\\.([0-9]+).*");
    private static final String STATE_TRANSITION_TIME = "stateTransitionTime";
    private static final String ACTION_TYPE_KEY = "actionType";
    private static final Logger LOG = LoggerFactory.getLogger(ArchivedTimelineLoaderV1.class);

    @Override
    public void loadInstants(HoodieTableMetaClient metaClient, @Nullable HoodieArchivedTimeline.TimeRangeFilter filter, HoodieArchivedTimeline.LoadMode loadMode, Function<GenericRecord, Boolean> commitsFilter, BiConsumer<String, GenericRecord> recordConsumer) {
        this.loadInstants(metaClient, filter, Option.empty(), loadMode, commitsFilter, recordConsumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadInstants(HoodieTableMetaClient metaClient, @Nullable HoodieArchivedTimeline.TimeRangeFilter filter, Option<ArchivedTimelineV1.LogFileFilter> logFileFilter, HoodieArchivedTimeline.LoadMode loadMode, Function<GenericRecord, Boolean> commitsFilter, BiConsumer<String, GenericRecord> recordConsumer) {
        HashSet instantsInRange = new HashSet();
        try {
            List<StoragePathInfo> entryList = metaClient.getStorage().globEntries(new StoragePath(metaClient.getArchivePath(), ".commits_.archive*"));
            entryList.sort(new ArchiveFileVersionComparator());
            for (StoragePathInfo fs : entryList) {
                if (logFileFilter.isPresent() && !logFileFilter.get().shouldLoadFile(fs)) continue;
                try {
                    HoodieLogFormat.Reader reader = HoodieLogFormat.newReader(metaClient.getStorage(), new HoodieLogFile(fs.getPath()), HoodieArchivedMetaEntry.getClassSchema());
                    Throwable throwable = null;
                    try {
                        int instantsInPreviousFile = instantsInRange.size();
                        while (reader.hasNext()) {
                            HoodieLogBlock block = (HoodieLogBlock)reader.next();
                            if (!(block instanceof HoodieAvroDataBlock)) continue;
                            HoodieAvroDataBlock avroBlock = (HoodieAvroDataBlock)block;
                            ClosableIterator itr = avroBlock.getRecordIterator(HoodieRecord.HoodieRecordType.AVRO);
                            Throwable throwable2 = null;
                            try {
                                StreamSupport.stream(Spliterators.spliteratorUnknownSize(itr, 1024), true).map(r -> (GenericRecord)r.getData()).filter(commitsFilter::apply).forEach(r -> {
                                    String instantTime = r.get("commitTime").toString();
                                    if (filter == null || filter.isInRange(instantTime)) {
                                        instantsInRange.add(instantTime);
                                        recordConsumer.accept(instantTime, (GenericRecord)r);
                                    }
                                });
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (itr == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        itr.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                itr.close();
                            }
                        }
                        if (filter == null) continue;
                        int instantsInCurrentFile = instantsInRange.size() - instantsInPreviousFile;
                        if (instantsInPreviousFile <= 0 || instantsInCurrentFile != 0) continue;
                        return;
                    }
                    catch (Throwable instantsInPreviousFile) {
                        throwable = instantsInPreviousFile;
                        throw instantsInPreviousFile;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable avroBlock) {
                                throwable.addSuppressed(avroBlock);
                            }
                            continue;
                        }
                        reader.close();
                    }
                }
                catch (Exception originalException) {
                    try {
                        HoodieMergeArchiveFilePlan plan;
                        String mergedArchiveFileName;
                        StoragePath planPath = new StoragePath(metaClient.getArchivePath(), MERGE_ARCHIVE_PLAN_NAME);
                        HoodieStorage storage = metaClient.getStorage();
                        if (!storage.exists(planPath) || StringUtils.isNullOrEmpty(mergedArchiveFileName = (plan = TimelineMetadataUtils.deserializeAvroMetadataLegacy(FileIOUtils.readDataFromPath(storage, planPath).get(), HoodieMergeArchiveFilePlan.class)).getMergedArchiveFileName()) || !fs.getPath().getName().equalsIgnoreCase(mergedArchiveFileName)) throw originalException;
                        LOG.warn("Catch exception because of reading uncompleted merging archive file " + mergedArchiveFileName + ". Ignore it here.");
                    }
                    catch (Exception e) {
                        throw originalException;
                        return;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not load archived commit timeline from path " + metaClient.getArchivePath(), e);
        }
    }

    public static class ArchiveFileVersionComparator
    implements Comparator<StoragePathInfo>,
    Serializable {
        @Override
        public int compare(StoragePathInfo f1, StoragePathInfo f2) {
            return Integer.compare(this.getArchivedFileSuffix(f2), this.getArchivedFileSuffix(f1));
        }

        private int getArchivedFileSuffix(StoragePathInfo f) {
            try {
                Matcher fileMatcher = ARCHIVE_FILE_PATTERN.matcher(f.getPath().getName());
                if (fileMatcher.matches()) {
                    return Integer.parseInt(fileMatcher.group(1));
                }
            }
            catch (NumberFormatException e) {
                LOG.warn("error getting suffix for archived file: " + f.getPath());
            }
            return 0;
        }
    }
}

