/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.StringUtils;

@ConfigClassProperty(name="Write commit callback configs", groupName=ConfigGroups.Names.WRITE_CLIENT, subGroupName=ConfigGroups.SubGroupNames.COMMIT_CALLBACK, areCommonConfigs=true, description="")
public class HoodieWriteCommitCallbackConfig
extends HoodieConfig {
    public static final String CALLBACK_PREFIX = "hoodie.write.commit.callback.";
    public static final ConfigProperty<Boolean> TURN_CALLBACK_ON = ConfigProperty.key("hoodie.write.commit.callback.on").defaultValue(false).markAdvanced().sinceVersion("0.6.0").withDocumentation("Turn commit callback on/off. off by default.");
    public static final ConfigProperty<String> CALLBACK_CLASS_NAME = ConfigProperty.key("hoodie.write.commit.callback.class").defaultValue("org.apache.hudi.callback.impl.HoodieWriteCommitHttpCallback").markAdvanced().sinceVersion("0.6.0").withDocumentation("Full path of callback class and must be a subclass of HoodieWriteCommitCallback class, org.apache.hudi.callback.impl.HoodieWriteCommitHttpCallback by default");
    public static final ConfigProperty<String> CALLBACK_HTTP_URL = ConfigProperty.key("hoodie.write.commit.callback.http.url").noDefaultValue().markAdvanced().sinceVersion("0.6.0").withDocumentation("Callback host to be sent along with callback messages");
    public static final ConfigProperty<String> CALLBACK_HTTP_API_KEY_VALUE = ConfigProperty.key("hoodie.write.commit.callback.http.api.key").defaultValue("hudi_write_commit_http_callback").markAdvanced().sinceVersion("0.6.0").withDocumentation("Http callback API key. hudi_write_commit_http_callback by default");
    public static final ConfigProperty<Integer> CALLBACK_HTTP_TIMEOUT_IN_SECONDS = ConfigProperty.key("hoodie.write.commit.callback.http.timeout.seconds").defaultValue(30).markAdvanced().sinceVersion("0.6.0").withDocumentation("Callback timeout in seconds.");
    public static final ConfigProperty<String> CALLBACK_HTTP_CUSTOM_HEADERS = ConfigProperty.key("hoodie.write.commit.callback.http.custom.headers").noDefaultValue().markAdvanced().sinceVersion("0.15.0").withDocumentation("Http callback custom headers. Format: HeaderName1:HeaderValue1;HeaderName2:HeaderValue2");
    @Deprecated
    public static final String CALLBACK_ON = TURN_CALLBACK_ON.key();
    @Deprecated
    public static final boolean DEFAULT_CALLBACK_ON = TURN_CALLBACK_ON.defaultValue();
    @Deprecated
    public static final String CALLBACK_CLASS_PROP = CALLBACK_CLASS_NAME.key();
    @Deprecated
    public static final String DEFAULT_CALLBACK_CLASS_PROP = CALLBACK_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String CALLBACK_HTTP_URL_PROP = CALLBACK_HTTP_URL.key();
    @Deprecated
    public static final String CALLBACK_HTTP_API_KEY = CALLBACK_HTTP_API_KEY_VALUE.key();
    @Deprecated
    public static final String DEFAULT_CALLBACK_HTTP_API_KEY = CALLBACK_HTTP_API_KEY_VALUE.defaultValue();
    @Deprecated
    public static final String CALLBACK_HTTP_TIMEOUT_SECONDS = CALLBACK_HTTP_TIMEOUT_IN_SECONDS.key();
    @Deprecated
    public static final int DEFAULT_CALLBACK_HTTP_TIMEOUT_SECONDS = CALLBACK_HTTP_TIMEOUT_IN_SECONDS.defaultValue();

    private HoodieWriteCommitCallbackConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final HoodieWriteCommitCallbackConfig writeCommitCallbackConfig = new HoodieWriteCommitCallbackConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.writeCommitCallbackConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.writeCommitCallbackConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder writeCommitCallbackOn(String callbackOn) {
            this.writeCommitCallbackConfig.setValue(TURN_CALLBACK_ON, callbackOn);
            return this;
        }

        public Builder withCallbackClass(String callbackClass) {
            this.writeCommitCallbackConfig.setValue(CALLBACK_CLASS_NAME, callbackClass);
            return this;
        }

        public Builder withCallbackHttpUrl(String url) {
            this.writeCommitCallbackConfig.setValue(CALLBACK_HTTP_URL, url);
            return this;
        }

        public Builder withCallbackHttpTimeoutSeconds(String timeoutSeconds) {
            this.writeCommitCallbackConfig.setValue(CALLBACK_HTTP_TIMEOUT_IN_SECONDS, timeoutSeconds);
            return this;
        }

        public Builder withCallbackHttpApiKey(String apiKey) {
            this.writeCommitCallbackConfig.setValue(CALLBACK_HTTP_API_KEY_VALUE, apiKey);
            return this;
        }

        public Builder withCustomHeaders(String customHeaders) {
            if (!StringUtils.isNullOrEmpty(customHeaders)) {
                this.writeCommitCallbackConfig.setValue(CALLBACK_HTTP_CUSTOM_HEADERS, customHeaders);
            }
            return this;
        }

        public HoodieWriteCommitCallbackConfig build() {
            this.writeCommitCallbackConfig.setDefaults(HoodieWriteCommitCallbackConfig.class.getName());
            return this.writeCommitCallbackConfig;
        }
    }
}

