/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import io.hops.hudi.org.apache.avro.Schema;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.SortUtils;
import org.apache.hudi.common.util.collection.FlatLists;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;

public class JavaCustomColumnsSortPartitioner<T>
implements BulkInsertPartitioner<List<HoodieRecord<T>>> {
    private final String[] sortColumnNames;
    private final Schema schema;
    private final boolean consistentLogicalTimestampEnabled;
    private final boolean suffixRecordKey;

    public JavaCustomColumnsSortPartitioner(String[] columnNames, Schema schema, HoodieWriteConfig config) {
        this.sortColumnNames = columnNames;
        this.schema = schema;
        this.consistentLogicalTimestampEnabled = config.isConsistentLogicalTimestampEnabled();
        this.suffixRecordKey = config.getBoolean(HoodieWriteConfig.BULKINSERT_SUFFIX_RECORD_KEY_SORT_COLUMNS);
    }

    @Override
    public List<HoodieRecord<T>> repartitionRecords(List<HoodieRecord<T>> records, int outputPartitions) {
        return records.stream().sorted((o1, o2) -> this.getComparableSortColumns((HoodieRecord)o1).compareTo(this.getComparableSortColumns((HoodieRecord)o2))).collect(Collectors.toList());
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }

    FlatLists.ComparableList<Comparable<HoodieRecord>> getComparableSortColumns(HoodieRecord record) {
        return SortUtils.getComparableSortColumns(record, this.sortColumnNames, this.schema, this.suffixRecordKey, this.consistentLogicalTimestampEnabled);
    }
}

