/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import io.hops.hudi.org.apache.avro.JsonProperties;
import io.hops.hudi.org.apache.avro.Schema;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.table.HoodieTable;

public class HoodieBootstrapHandle<T, I, K, O>
extends HoodieCreateHandle<T, I, K, O> {
    public static final Schema METADATA_BOOTSTRAP_RECORD_SCHEMA = HoodieBootstrapHandle.createMetadataBootstrapRecordSchema();

    public HoodieBootstrapHandle(HoodieWriteConfig config, String commitTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        super(config, commitTime, hoodieTable, partitionPath, fileId, Option.of(METADATA_BOOTSTRAP_RECORD_SCHEMA), taskContextSupplier);
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return true;
    }

    private static Schema createMetadataBootstrapRecordSchema() {
        List<Schema.Field> fields = HoodieRecord.HOODIE_META_COLUMNS.stream().map(metaField -> new Schema.Field((String)metaField, AvroSchemaUtils.createNullableSchema(Schema.Type.STRING), "", JsonProperties.NULL_VALUE)).collect(Collectors.toList());
        return Schema.createRecord("HoodieRecordKey", "", "", false, fields);
    }
}

