/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import io.hops.hudi.org.apache.avro.Schema;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ClusteringOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.log.HoodieFileSliceReader;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClusteringExecutionStrategy<T, I, K, O>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringExecutionStrategy.class);
    private final HoodieTable<T, I, K, O> hoodieTable;
    private final transient HoodieEngineContext engineContext;
    protected final HoodieWriteConfig writeConfig;
    protected final HoodieRecord.HoodieRecordType recordType;
    protected final Schema readerSchemaWithMetaFields;

    public ClusteringExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
        this.hoodieTable = table;
        this.engineContext = engineContext;
        this.recordType = table.getConfig().getRecordMerger().getRecordType();
        this.readerSchemaWithMetaFields = HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(writeConfig.getSchema()));
    }

    public abstract HoodieWriteMetadata<O> performClustering(HoodieClusteringPlan var1, Schema var2, String var3);

    protected HoodieTable<T, I, K, O> getHoodieTable() {
        return this.hoodieTable;
    }

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    protected HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }

    protected ClosableIterator<HoodieRecord<T>> getRecordIteratorWithLogFiles(ClusteringOperation operation, String instantTime, long maxMemory, Option<BaseKeyGenerator> keyGeneratorOpt, Option<HoodieFileReader> baseFileReaderOpt) {
        HoodieWriteConfig config = this.getWriteConfig();
        HoodieTable<T, I, K, O> table = this.getHoodieTable();
        HoodieTableConfig tableConfig = table.getMetaClient().getTableConfig();
        HoodieMergedLogRecordScanner scanner = ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withStorage(table.getStorage()).withBasePath(table.getMetaClient().getBasePath()).withLogFilePaths((List)operation.getDeltaFilePaths())).withReaderSchema(this.readerSchemaWithMetaFields).withLatestInstantTime(instantTime).withMaxMemorySizeInBytes(maxMemory).withReverseReader(config.getCompactionReverseLogReadEnabled()).withBufferSize(config.getMaxDFSStreamBufferSize()).withSpillableMapBasePath(config.getSpillableMapBasePath()).withPartition(operation.getPartitionPath()).withOptimizedLogBlocksScan(config.enableOptimizedLogBlocksScan()).withDiskMapType(config.getCommonConfig().getSpillableDiskMapType()).withBitCaskDiskMapCompressionEnabled(config.getCommonConfig().isBitCaskDiskMapCompressionEnabled()).withRecordMerger(config.getRecordMerger()).withTableMetaClient(table.getMetaClient()).build();
        try {
            return new HoodieFileSliceReader(baseFileReaderOpt, scanner, this.readerSchemaWithMetaFields, tableConfig.getPreCombineField(), config.getRecordMerger(), tableConfig.getProps(), tableConfig.populateMetaFields() ? Option.empty() : Option.of(Pair.of(tableConfig.getRecordKeyFieldProp(), tableConfig.getPartitionFieldProp())), keyGeneratorOpt);
        }
        catch (IOException e) {
            throw new HoodieClusteringException("Error reading file slices", e);
        }
    }

    protected ClosableIterator<HoodieRecord<T>> getRecordIteratorWithBaseFileOnly(Option<BaseKeyGenerator> keyGeneratorOpt, HoodieFileReader baseFileReader) {
        ClosableIterator baseRecordsIterator;
        try {
            baseRecordsIterator = baseFileReader.getRecordIterator(this.readerSchemaWithMetaFields);
        }
        catch (IOException e) {
            throw new HoodieClusteringException("Error reading base file", e);
        }
        return new CloseableMappingIterator<Object, Object>(baseRecordsIterator, rec -> ((HoodieRecord)rec).copy().wrapIntoHoodieRecordPayloadWithKeyGen(this.readerSchemaWithMetaFields, this.writeConfig.getProps(), keyGeneratorOpt));
    }
}

