/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.JavaLazyInsertIterable;
import org.apache.hudi.execution.bulkinsert.JavaBulkInsertInternalPartitionerFactory;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.metadata.JavaHoodieMetadataBulkInsertPartitioner;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.FileIdPrefixProvider;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseBulkInsertHelper;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaWriteHelper;

public class JavaBulkInsertHelper<T, R>
extends BaseBulkInsertHelper<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> {
    private JavaBulkInsertHelper() {
        super((I ignored) -> -1);
    }

    public static JavaBulkInsertHelper newInstance() {
        return BulkInsertHelperHolder.JAVA_BULK_INSERT_HELPER;
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> bulkInsert(List<HoodieRecord<T>> inputRecords, String instantTime, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, HoodieWriteConfig config, BaseCommitActionExecutor<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> executor, boolean performDedupe, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        HoodieWriteMetadata<List<WriteStatus>> result = new HoodieWriteMetadata<List<WriteStatus>>();
        if (!table.getActiveTimeline().filterInflights().containsInstant(instantTime)) {
            table.getActiveTimeline().transitionRequestedToInflight(table.getInstantGenerator().createNewInstant(HoodieInstant.State.REQUESTED, table.getMetaClient().getCommitActionType(), instantTime), Option.empty(), config.shouldAllowMultiWriteOnSameInstant());
        }
        BulkInsertPartitioner partitioner = userDefinedBulkInsertPartitioner.orElseGet(() -> JavaBulkInsertInternalPartitionerFactory.get(config.getBulkInsertSortMode()));
        List<WriteStatus> writeStatuses = this.bulkInsert(inputRecords, instantTime, table, config, performDedupe, partitioner, false, config.getBulkInsertShuffleParallelism(), (WriteHandleFactory)new CreateHandleFactory(false));
        ((BaseJavaCommitActionExecutor)executor).updateIndexAndCommitIfNeeded(writeStatuses, result);
        return result;
    }

    @Override
    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> inputRecords, String instantTime, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table, HoodieWriteConfig config, boolean performDedupe, BulkInsertPartitioner partitioner, boolean useWriterSchema, int configuredParallelism, WriteHandleFactory writeHandleFactory) {
        String fileIdPrefix;
        List<HoodieRecord<T>> dedupedRecords = inputRecords;
        int targetParallelism = this.deduceShuffleParallelism(inputRecords, configuredParallelism);
        if (performDedupe) {
            dedupedRecords = JavaWriteHelper.newInstance().combineOnCondition(config.shouldCombineBeforeInsert(), inputRecords, targetParallelism, table);
        }
        List<HoodieRecord<T>> repartitionedRecords = partitioner.repartitionRecords(dedupedRecords, targetParallelism);
        if (partitioner instanceof JavaHoodieMetadataBulkInsertPartitioner) {
            fileIdPrefix = partitioner.getFileIdPfx(0);
        } else {
            FileIdPrefixProvider fileIdPrefixProvider = (FileIdPrefixProvider)ReflectionUtils.loadClass(config.getFileIdPrefixProviderClassName(), config.getProps());
            fileIdPrefix = fileIdPrefixProvider.createFilePrefix("");
        }
        ArrayList<WriteStatus> writeStatuses = new ArrayList<WriteStatus>();
        new JavaLazyInsertIterable<T>(repartitionedRecords.iterator(), true, config, instantTime, table, fileIdPrefix, table.getTaskContextSupplier(), partitioner.getWriteHandleFactory(0).orElse(writeHandleFactory)).forEachRemaining(writeStatuses::addAll);
        return writeStatuses;
    }

    private static class BulkInsertHelperHolder {
        private static final JavaBulkInsertHelper JAVA_BULK_INSERT_HELPER = new JavaBulkInsertHelper();

        private BulkInsertHelperHolder() {
        }
    }
}

