/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.timeline.versioning.v2.LSMTimelineWriter;
import org.apache.hudi.client.utils.LegacyArchivedMetaEntryReader;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.BootstrapIndexType;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.versioning.v1.ActiveTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.CommitMetadataSerDeV1;
import org.apache.hudi.common.table.timeline.versioning.v2.ActiveTimelineV2;
import org.apache.hudi.common.table.timeline.versioning.v2.CommitMetadataSerDeV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.apache.hudi.table.upgrade.UpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenToEightUpgradeHandler
implements UpgradeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SevenToEightUpgradeHandler.class);

    @Override
    public Map<ConfigProperty, String> upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        List<HoodieInstant> instants;
        HashMap<ConfigProperty, String> tablePropsToAdd = new HashMap<ConfigProperty, String>();
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTableMetaClient metaClient = table.getMetaClient();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        if (!config.autoUpgrade()) {
            config.setValue(HoodieWriteConfig.WRITE_TABLE_VERSION, String.valueOf(HoodieTableVersion.SIX.versionCode()));
            return tablePropsToAdd;
        }
        if (!table.isMetadataTable() && config.isMetadataTableEnabled() && SevenToEightUpgradeHandler.isMetadataTableBehindDataTable(config, metaClient)) {
            HoodieTableMetadataUtil.deleteMetadataTable(config.getBasePath(), context);
        }
        UpgradeDowngradeUtils.rollbackFailedWritesAndCompact(table, context, config, upgradeDowngradeHelper, HoodieTableType.MERGE_ON_READ.equals((Object)table.getMetaClient().getTableType()), HoodieTableVersion.SIX);
        try {
            HoodieTableMetaClient.createTableLayoutOnStorage(context.getStorageConf(), new StoragePath(config.getBasePath()), config.getProps(), TimelineLayoutVersion.VERSION_2, false);
        }
        catch (IOException e) {
            LOG.error("Failed to create table layout on storage for timeline layout version {}", (Object)TimelineLayoutVersion.VERSION_2, (Object)e);
            throw new HoodieIOException("Failed to create table layout on storage", e);
        }
        tablePropsToAdd.put(HoodieTableConfig.TIMELINE_PATH, HoodieTableConfig.TIMELINE_PATH.defaultValue());
        SevenToEightUpgradeHandler.upgradePartitionFields(config, tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.upgradeMergeMode(tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.setInitialVersion(tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.upgradeKeyGeneratorType(tableConfig, tablePropsToAdd);
        SevenToEightUpgradeHandler.upgradeBootstrapIndexType(tableConfig, tablePropsToAdd);
        try {
            instants = metaClient.scanHoodieInstantsFromFileSystem(metaClient.getTimelinePath(), ActiveTimelineV1.VALID_EXTENSIONS_IN_ACTIVE_TIMELINE, false);
        }
        catch (IOException ioe) {
            LOG.error("Failed to get instants from filesystem", (Throwable)ioe);
            throw new HoodieIOException("Failed to get instants from filesystem", ioe);
        }
        if (!instants.isEmpty()) {
            InstantFileNameGenerator instantFileNameGenerator = metaClient.getInstantFileNameGenerator();
            CommitMetadataSerDeV2 commitMetadataSerDeV2 = new CommitMetadataSerDeV2();
            CommitMetadataSerDeV1 commitMetadataSerDeV1 = new CommitMetadataSerDeV1();
            ActiveTimelineV2 activeTimelineV2 = new ActiveTimelineV2(metaClient);
            context.map(instants, instant -> {
                String originalFileName = instantFileNameGenerator.getFileName((HoodieInstant)instant);
                return SevenToEightUpgradeHandler.upgradeActiveTimelineInstant(instant, originalFileName, metaClient, commitMetadataSerDeV1, commitMetadataSerDeV2, activeTimelineV2);
            }, instants.size());
        }
        SevenToEightUpgradeHandler.upgradeToLSMTimeline(table, context, config);
        return tablePropsToAdd;
    }

    private static boolean isMetadataTableBehindDataTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
        if (!metaClient.getTableConfig().isMetadataTableAvailable()) {
            return false;
        }
        HoodieInstant lastCommitInstantInDataTable = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().orElse(null);
        HoodieTableMetaClient metadataTableMetaClient = HoodieTableMetaClient.builder().setConf(metaClient.getStorageConf().newInstance()).setBasePath(HoodieTableMetadata.getMetadataTableBasePath(config.getBasePath())).build();
        HoodieInstant lastCommitInstantInMetadataTable = metadataTableMetaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().orElse(null);
        return lastCommitInstantInDataTable != null && lastCommitInstantInMetadataTable != null && InstantComparison.compareTimestamps(lastCommitInstantInMetadataTable.requestedTime(), InstantComparison.LESSER_THAN, lastCommitInstantInDataTable.requestedTime());
    }

    static void upgradePartitionFields(HoodieWriteConfig config, HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String keyGenerator = tableConfig.getKeyGeneratorClassName();
        String partitionPathField = config.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        if (keyGenerator != null && partitionPathField != null && (keyGenerator.equals(KeyGeneratorType.CUSTOM.getClassName()) || keyGenerator.equals(KeyGeneratorType.CUSTOM_AVRO.getClassName()))) {
            tablePropsToAdd.put(HoodieTableConfig.PARTITION_FIELDS, partitionPathField);
        }
    }

    static void upgradeMergeMode(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String payloadClass = tableConfig.getPayloadClass();
        String preCombineField = tableConfig.getPreCombineField();
        if (SevenToEightUpgradeHandler.isCustomPayloadClass(payloadClass)) {
            tablePropsToAdd.put(HoodieTableConfig.PAYLOAD_CLASS_NAME, payloadClass);
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.CUSTOM.name());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "00000000-0000-0000-0000-000000000000");
        } else if (tableConfig.getTableType() == HoodieTableType.COPY_ON_WRITE) {
            SevenToEightUpgradeHandler.setEventTimeOrCommitTimeBasedOnPayload(payloadClass, tablePropsToAdd);
        } else if (StringUtils.nonEmpty(preCombineField)) {
            tablePropsToAdd.put(HoodieTableConfig.PAYLOAD_CLASS_NAME, DefaultHoodieRecordPayload.class.getName());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.EVENT_TIME_ORDERING.name());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5");
        } else {
            SevenToEightUpgradeHandler.setEventTimeOrCommitTimeBasedOnPayload(payloadClass, tablePropsToAdd);
        }
    }

    private static void setEventTimeOrCommitTimeBasedOnPayload(String payloadClass, Map<ConfigProperty, String> tablePropsToAdd) {
        if (SevenToEightUpgradeHandler.useDefaultHoodieRecordPayload(payloadClass)) {
            tablePropsToAdd.put(HoodieTableConfig.PAYLOAD_CLASS_NAME, DefaultHoodieRecordPayload.class.getName());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.EVENT_TIME_ORDERING.name());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5");
        } else {
            tablePropsToAdd.put(HoodieTableConfig.PAYLOAD_CLASS_NAME, OverwriteWithLatestAvroPayload.class.getName());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.COMMIT_TIME_ORDERING.name());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "ce9acb64-bde0-424c-9b91-f6ebba25356d");
        }
    }

    static boolean useDefaultHoodieRecordPayload(String payloadClass) {
        return !StringUtils.isNullOrEmpty(payloadClass) && payloadClass.equals(DefaultHoodieRecordPayload.class.getName());
    }

    static boolean isCustomPayloadClass(String payloadClass) {
        return !StringUtils.isNullOrEmpty(payloadClass) && !payloadClass.equals(DefaultHoodieRecordPayload.class.getName()) && !payloadClass.equals(OverwriteWithLatestAvroPayload.class.getName());
    }

    static void setInitialVersion(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        if (tableConfig.contains(HoodieTableConfig.VERSION)) {
            tablePropsToAdd.put(HoodieTableConfig.INITIAL_VERSION, String.valueOf(tableConfig.getTableVersion().versionCode()));
        } else {
            tablePropsToAdd.put(HoodieTableConfig.INITIAL_VERSION, String.valueOf(HoodieTableVersion.SIX.versionCode()));
        }
    }

    static void upgradeBootstrapIndexType(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String bootstrapIndexClass;
        if ((tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME) || tableConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE)) && StringUtils.nonEmpty(bootstrapIndexClass = BootstrapIndexType.getBootstrapIndexClassName(tableConfig))) {
            tablePropsToAdd.put(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME, bootstrapIndexClass);
            tablePropsToAdd.put(HoodieTableConfig.BOOTSTRAP_INDEX_TYPE, BootstrapIndexType.fromClassName(bootstrapIndexClass).name());
        }
    }

    static void upgradeKeyGeneratorType(HoodieTableConfig tableConfig, Map<ConfigProperty, String> tablePropsToAdd) {
        String keyGenerator = tableConfig.getKeyGeneratorClassName();
        if (StringUtils.nonEmpty(keyGenerator)) {
            tablePropsToAdd.put(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, keyGenerator);
            tablePropsToAdd.put(HoodieTableConfig.KEY_GENERATOR_TYPE, KeyGeneratorType.fromClassName(keyGenerator).name());
        }
    }

    static void upgradeToLSMTimeline(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig config) {
        table.getMetaClient().getTableConfig().getTimelineLayoutVersion().ifPresent(timelineLayoutVersion -> ValidationUtils.checkState(TimelineLayoutVersion.LAYOUT_VERSION_1.equals(timelineLayoutVersion), "Upgrade to LSM timeline is only supported for layout version 1. Given version: " + timelineLayoutVersion));
        try {
            LegacyArchivedMetaEntryReader reader = new LegacyArchivedMetaEntryReader(table.getMetaClient());
            StoragePath archivePath = new StoragePath(table.getMetaClient().getMetaPath(), "timeline/history");
            LSMTimelineWriter lsmTimelineWriter = LSMTimelineWriter.getInstance(config, table, Option.of(archivePath));
            int batchSize = config.getCommitArchivalBatchSize();
            ArrayList activeActionsBatch = new ArrayList(batchSize);
            try (ClosableIterator<ActiveAction> iterator = reader.getActiveActionsIterator();){
                while (iterator.hasNext()) {
                    activeActionsBatch.add(iterator.next());
                    if (activeActionsBatch.size() != batchSize) continue;
                    lsmTimelineWriter.write(new ArrayList<ActiveAction>(activeActionsBatch), Option.empty(), Option.empty());
                    lsmTimelineWriter.compactAndClean(engineContext);
                    activeActionsBatch.clear();
                }
                if (!activeActionsBatch.isEmpty()) {
                    lsmTimelineWriter.write(new ArrayList<ActiveAction>(activeActionsBatch), Option.empty(), Option.empty());
                    lsmTimelineWriter.compactAndClean(engineContext);
                }
            }
        }
        catch (Exception e) {
            if (config.isFailOnTimelineArchivingEnabled()) {
                throw new HoodieException("Failed to upgrade to LSM timeline", e);
            }
            LOG.warn("Failed to upgrade to LSM timeline");
        }
    }

    static boolean upgradeActiveTimelineInstant(HoodieInstant instant, String originalFileName, HoodieTableMetaClient metaClient, CommitMetadataSerDeV1 commitMetadataSerDeV1, CommitMetadataSerDeV2 commitMetadataSerDeV2, ActiveTimelineV2 activeTimelineV2) {
        String replacedFileName = originalFileName;
        boolean isCompleted = instant.isCompleted();
        if (isCompleted) {
            String completionTime = instant.getCompletionTime();
            String startTime = instant.requestedTime();
            replacedFileName = replacedFileName.replace(startTime, startTime + "_" + completionTime);
        }
        if (UpgradeDowngradeUtils.SIX_TO_EIGHT_TIMELINE_ACTION_MAP.containsKey(instant.getAction()) && !isCompleted) {
            replacedFileName = replacedFileName.replace(instant.getAction(), UpgradeDowngradeUtils.SIX_TO_EIGHT_TIMELINE_ACTION_MAP.get(instant.getAction()));
        }
        try {
            return SevenToEightUpgradeHandler.rewriteTimelineV1InstantFileToV2Format(instant, metaClient, originalFileName, replacedFileName, commitMetadataSerDeV1, commitMetadataSerDeV2, activeTimelineV2);
        }
        catch (IOException e) {
            LOG.warn("Can not to complete the upgrade from version seven to version eight. The reason for failure is {}", (Object)e.getMessage());
            return false;
        }
    }

    static boolean rewriteTimelineV1InstantFileToV2Format(HoodieInstant instant, HoodieTableMetaClient metaClient, String originalFileName, String replacedFileName, CommitMetadataSerDeV1 commitMetadataSerDeV1, CommitMetadataSerDeV2 commitMetadataSerDeV2, ActiveTimelineV2 activeTimelineV2) throws IOException {
        StoragePath fromPath = new StoragePath(TimelineLayout.TIMELINE_LAYOUT_V1.getTimelinePathProvider().getTimelinePath(metaClient.getTableConfig(), metaClient.getBasePath()), originalFileName);
        StoragePath toPath = new StoragePath(TimelineLayout.TIMELINE_LAYOUT_V2.getTimelinePathProvider().getTimelinePath(metaClient.getTableConfig(), metaClient.getBasePath()), replacedFileName);
        boolean success = true;
        if (instant.getAction().equals("commit") || instant.getAction().equals("deltacommit") || instant.getAction().equals("replacecommit") && instant.isCompleted()) {
            Class clazz = instant.getAction().equals("replacecommit") ? HoodieReplaceCommitMetadata.class : HoodieCommitMetadata.class;
            HoodieCommitMetadata commitMetadata = metaClient.getActiveTimeline().readInstantContent(instant, clazz);
            String toPathStr = toPath.toUri().toString();
            activeTimelineV2.createFileInMetaPath(toPathStr, Option.of(commitMetadata), true);
            metaClient.getStorage().deleteFile(fromPath);
        } else {
            success = metaClient.getStorage().rename(fromPath, toPath);
        }
        if (!success) {
            throw new HoodieIOException("an error that occurred while renaming " + fromPath + " to: " + toPath);
        }
        return true;
    }
}

