/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.client.http;

import io.hops.hudi.org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import io.hops.hudi.org.eclipse.jetty.client.DuplexConnectionPool;
import io.hops.hudi.org.eclipse.jetty.client.HttpDestination;
import io.hops.hudi.org.eclipse.jetty.client.Origin;
import io.hops.hudi.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import io.hops.hudi.org.eclipse.jetty.client.http.HttpDestinationOverHTTP;
import io.hops.hudi.org.eclipse.jetty.io.Connection;
import io.hops.hudi.org.eclipse.jetty.io.EndPoint;
import io.hops.hudi.org.eclipse.jetty.util.ProcessorUtils;
import io.hops.hudi.org.eclipse.jetty.util.Promise;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import java.io.IOException;
import java.util.Map;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractConnectorHttpClientTransport {
    public HttpClientTransportOverHTTP() {
        this(Math.max(1, ProcessorUtils.availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
        this.setConnectionPoolFactory(destination -> new DuplexConnectionPool(destination, this.getHttpClient().getMaxConnectionsPerDestination(), destination));
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<io.hops.hudi.org.eclipse.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }
}

