/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.server;

import io.hops.hudi.org.eclipse.jetty.io.ByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.io.ChannelEndPoint;
import io.hops.hudi.org.eclipse.jetty.io.ManagedSelector;
import io.hops.hudi.org.eclipse.jetty.io.NetworkTrafficListener;
import io.hops.hudi.org.eclipse.jetty.io.NetworkTrafficSelectChannelEndPoint;
import io.hops.hudi.org.eclipse.jetty.server.ConnectionFactory;
import io.hops.hudi.org.eclipse.jetty.server.HttpConnectionFactory;
import io.hops.hudi.org.eclipse.jetty.server.Server;
import io.hops.hudi.org.eclipse.jetty.server.ServerConnector;
import io.hops.hudi.org.eclipse.jetty.util.ssl.SslContextFactory;
import io.hops.hudi.org.eclipse.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;

public class NetworkTrafficServerConnector
extends ServerConnector {
    private final List<NetworkTrafficListener> listeners = new CopyOnWriteArrayList<NetworkTrafficListener>();

    public NetworkTrafficServerConnector(Server server) {
        this(server, null, null, null, 0, 0, new HttpConnectionFactory());
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, ConnectionFactory connectionFactory) {
        super(server, connectionFactory);
    }

    public NetworkTrafficServerConnector(Server server, Executor executor, Scheduler scheduler, ByteBufferPool pool, int acceptors, int selectors, ConnectionFactory ... factories) {
        super(server, executor, scheduler, pool, acceptors, selectors, factories);
    }

    public NetworkTrafficServerConnector(Server server, SslContextFactory sslContextFactory) {
        super(server, sslContextFactory);
    }

    public void addNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.add(listener);
    }

    public void removeNetworkTrafficListener(NetworkTrafficListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    protected ChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) throws IOException {
        NetworkTrafficSelectChannelEndPoint endPoint = new NetworkTrafficSelectChannelEndPoint(channel, selectSet, key, this.getScheduler(), this.getIdleTimeout(), this.listeners);
        return endPoint;
    }
}

