/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.webapp;

import io.hops.hudi.org.eclipse.jetty.server.Server;
import io.hops.hudi.org.eclipse.jetty.util.annotation.Name;
import io.hops.hudi.org.eclipse.jetty.webapp.WebAppContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public interface Configuration {
    public static final String ATTR = "io.hops.hudi.org.eclipse.jetty.webapp.configuration";

    public void preConfigure(WebAppContext var1) throws Exception;

    public void configure(WebAppContext var1) throws Exception;

    public void postConfigure(WebAppContext var1) throws Exception;

    public void deconfigure(WebAppContext var1) throws Exception;

    public void destroy(WebAppContext var1) throws Exception;

    public void cloneConfigure(WebAppContext var1, WebAppContext var2) throws Exception;

    public static class ClassList
    extends ArrayList<String> {
        public static ClassList setServerDefault(Server server) {
            ClassList cl = server.getBean(ClassList.class);
            if (cl != null) {
                return cl;
            }
            cl = ClassList.serverDefault(server);
            server.addBean(cl);
            server.setAttribute(Configuration.ATTR, null);
            return cl;
        }

        public static ClassList serverDefault(Server server) {
            ClassList cl = null;
            if (server != null) {
                cl = server.getBean(ClassList.class);
                if (cl != null) {
                    return new ClassList(cl);
                }
                Object attr = server.getAttribute(Configuration.ATTR);
                if (attr instanceof ClassList) {
                    return new ClassList((ClassList)attr);
                }
                if (attr instanceof String[]) {
                    return new ClassList((String[])attr);
                }
            }
            return new ClassList();
        }

        public ClassList() {
            this(WebAppContext.DEFAULT_CONFIGURATION_CLASSES);
        }

        public ClassList(String[] classes) {
            this.addAll(Arrays.asList(classes));
        }

        public ClassList(List<String> classes) {
            this.addAll(classes);
        }

        public void addAfter(@Name(value="afterClass") String afterClass, String ... configClass) {
            if (configClass != null && afterClass != null) {
                ListIterator<String> iter = this.listIterator();
                while (iter.hasNext()) {
                    String cc = (String)iter.next();
                    if (!afterClass.equals(cc)) continue;
                    for (int i = 0; i < configClass.length; ++i) {
                        iter.add(configClass[i]);
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("afterClass '" + afterClass + "' not found in " + this);
        }

        public void addBefore(@Name(value="beforeClass") String beforeClass, String ... configClass) {
            if (configClass != null && beforeClass != null) {
                ListIterator<String> iter = this.listIterator();
                while (iter.hasNext()) {
                    String cc = (String)iter.next();
                    if (!beforeClass.equals(cc)) continue;
                    iter.previous();
                    for (int i = 0; i < configClass.length; ++i) {
                        iter.add(configClass[i]);
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("beforeClass '" + beforeClass + "' not found in " + this);
        }

        public void replace(@Name(value="replaceClass") String replaceClass, @Name(value="configClass") String configClass) {
            if (replaceClass != null && configClass != null) {
                ListIterator<String> iter = this.listIterator();
                while (iter.hasNext()) {
                    String cc = (String)iter.next();
                    if (!replaceClass.equals(cc)) continue;
                    iter.set(configClass);
                    return;
                }
            }
            throw new IllegalArgumentException("replaceClass '" + replaceClass + "' not found in " + this);
        }
    }
}

