/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.common.scopes;

import io.hops.hudi.org.eclipse.jetty.io.ByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.io.MappedByteBufferPool;
import io.hops.hudi.org.eclipse.jetty.util.DecoratedObjectFactory;
import io.hops.hudi.org.eclipse.jetty.util.DeprecationWarning;
import io.hops.hudi.org.eclipse.jetty.util.component.ContainerLifeCycle;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.util.ssl.SslContextFactory;
import io.hops.hudi.org.eclipse.jetty.util.thread.QueuedThreadPool;
import io.hops.hudi.org.eclipse.jetty.websocket.api.WebSocketBehavior;
import io.hops.hudi.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import io.hops.hudi.org.eclipse.jetty.websocket.common.WebSocketSessionListener;
import io.hops.hudi.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;

public class SimpleContainerScope
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private final ByteBufferPool bufferPool;
    private final DecoratedObjectFactory objectFactory;
    private final WebSocketPolicy policy;
    private final Executor executor;
    private final Logger logger;
    private SslContextFactory sslContextFactory;
    private List<WebSocketSessionListener> sessionListeners = new ArrayList<WebSocketSessionListener>();

    public SimpleContainerScope(WebSocketPolicy policy) {
        this(policy, new MappedByteBufferPool(), new DecoratedObjectFactory());
        this.sslContextFactory = new SslContextFactory();
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool) {
        this(policy, bufferPool, new DecoratedObjectFactory());
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory) {
        this(policy, bufferPool, null, objectFactory);
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool, Executor executor, DecoratedObjectFactory objectFactory) {
        this(policy, bufferPool, executor, null, objectFactory);
    }

    public SimpleContainerScope(WebSocketPolicy policy, ByteBufferPool bufferPool, Executor executor, SslContextFactory ssl, DecoratedObjectFactory objectFactory) {
        this.logger = Log.getLogger(this.getClass());
        this.policy = policy;
        this.bufferPool = bufferPool;
        if (objectFactory == null) {
            this.objectFactory = new DecoratedObjectFactory();
            this.objectFactory.addDecorator(new DeprecationWarning());
        } else {
            this.objectFactory = objectFactory;
        }
        this.sslContextFactory = ssl == null ? new SslContextFactory() : ssl;
        if (executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String behavior = "Container";
            if (policy != null) {
                if (policy.getBehavior() == WebSocketBehavior.CLIENT) {
                    behavior = "Client";
                } else if (policy.getBehavior() == WebSocketBehavior.SERVER) {
                    behavior = "Server";
                }
            }
            String name = String.format("WebSocket%s@%s", behavior, this.hashCode());
            threadPool.setName(name);
            threadPool.setDaemon(true);
            this.executor = threadPool;
            this.addBean(this.executor);
        } else {
            this.executor = executor;
        }
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public void addSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.add(listener);
    }

    @Override
    public void removeSessionListener(WebSocketSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    @Override
    public Collection<WebSocketSessionListener> getSessionListeners() {
        return this.sessionListeners;
    }
}

