/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.CellCodec;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellCodec {
    @Test
    public void testEmptyWorks() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        CellCodec codec = new CellCodec();
        Codec.Encoder encoder2 = codec.getEncoder(dos);
        encoder2.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)0L, (long)offset);
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder2 = codec.getDecoder(dis);
        Assert.assertFalse((boolean)decoder2.advance());
        dis.close();
        Assert.assertEquals((long)0L, (long)cis.getCount());
    }

    @Test
    public void testOne() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        CellCodec codec = new CellCodec();
        Codec.Encoder encoder2 = codec.getEncoder(dos);
        KeyValue kv = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("q"), Bytes.toBytes("v"));
        kv.setSequenceId(Long.MAX_VALUE);
        encoder2.write(kv);
        encoder2.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder2 = codec.getDecoder(dis);
        Assert.assertTrue((boolean)decoder2.advance());
        Assert.assertFalse((boolean)decoder2.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }

    @Test
    public void testThree() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        CellCodec codec = new CellCodec();
        Codec.Encoder encoder2 = codec.getEncoder(dos);
        KeyValue kv1 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("1"), Bytes.toBytes("1"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("2"), Bytes.toBytes("2"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("3"), Bytes.toBytes("3"));
        encoder2.write(kv1);
        encoder2.write(kv2);
        encoder2.write(kv3);
        encoder2.flush();
        dos.close();
        long offset = cos.getCount();
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder2 = codec.getDecoder(dis);
        Assert.assertTrue((boolean)decoder2.advance());
        Cell c = decoder2.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv1));
        Assert.assertTrue((boolean)decoder2.advance());
        c = decoder2.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv2));
        Assert.assertTrue((boolean)decoder2.advance());
        c = decoder2.current();
        Assert.assertTrue((boolean)CellComparator.equals(c, kv3));
        Assert.assertFalse((boolean)decoder2.advance());
        dis.close();
        Assert.assertEquals((long)offset, (long)cis.getCount());
    }
}

