/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec;

import com.google.common.io.CountingInputStream;
import com.google.common.io.CountingOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.codec.KeyValueCodec;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyValueCodec {
    @Test
    public void testEmptyWorks() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        KeyValueCodec kvc = new KeyValueCodec();
        Codec.Encoder encoder2 = kvc.getEncoder(dos);
        encoder2.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)0L, (long)offset);
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder2 = kvc.getDecoder(dis);
        Assert.assertFalse((boolean)decoder2.advance());
        dis.close();
        Assert.assertEquals((long)0L, (long)cis.getCount());
    }

    @Test
    public void testOne() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        KeyValueCodec kvc = new KeyValueCodec();
        Codec.Encoder encoder2 = kvc.getEncoder(dos);
        KeyValue kv = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("q"), Bytes.toBytes("v"));
        long length = kv.getLength() + 4;
        encoder2.write(kv);
        encoder2.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)length, (long)offset);
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder2 = kvc.getDecoder(dis);
        Assert.assertTrue((boolean)decoder2.advance());
        Assert.assertFalse((boolean)decoder2.advance());
        dis.close();
        Assert.assertEquals((long)length, (long)cis.getCount());
    }

    @Test
    public void testThree() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);
        DataOutputStream dos = new DataOutputStream((OutputStream)cos);
        KeyValueCodec kvc = new KeyValueCodec();
        Codec.Encoder encoder2 = kvc.getEncoder(dos);
        KeyValue kv1 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("1"), Bytes.toBytes("1"));
        KeyValue kv2 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("2"), Bytes.toBytes("2"));
        KeyValue kv3 = new KeyValue(Bytes.toBytes("r"), Bytes.toBytes("f"), Bytes.toBytes("3"), Bytes.toBytes("3"));
        long length = kv1.getLength() + 4;
        encoder2.write(kv1);
        encoder2.write(kv2);
        encoder2.write(kv3);
        encoder2.flush();
        dos.close();
        long offset = cos.getCount();
        Assert.assertEquals((long)(length * 3L), (long)offset);
        CountingInputStream cis = new CountingInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        DataInputStream dis = new DataInputStream((InputStream)cis);
        Codec.Decoder decoder2 = kvc.getDecoder(dis);
        Assert.assertTrue((boolean)decoder2.advance());
        KeyValue kv = (KeyValue)decoder2.current();
        Assert.assertTrue((boolean)kv1.equals(kv));
        Assert.assertTrue((boolean)decoder2.advance());
        kv = (KeyValue)decoder2.current();
        Assert.assertTrue((boolean)kv2.equals(kv));
        Assert.assertTrue((boolean)decoder2.advance());
        kv = (KeyValue)decoder2.current();
        Assert.assertTrue((boolean)kv3.equals(kv));
        Assert.assertFalse((boolean)decoder2.advance());
        dis.close();
        Assert.assertEquals((long)(length * 3L), (long)cis.getCount());
    }
}

