/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public final class ByteBufferArray {
    private static final Log LOG = LogFactory.getLog(ByteBufferArray.class);
    static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private ByteBuffer[] buffers;
    private Lock[] locks;
    private int bufferSize = 0x400000;
    private int bufferCount;
    private static final Visitor GET_MULTIPLE_VISTOR = new Visitor(){

        @Override
        public void visit(ByteBuffer bb, byte[] array2, int arrayIdx, int len) {
            bb.get(array2, arrayIdx, len);
        }
    };
    private static final Visitor PUT_MULTIPLE_VISITOR = new Visitor(){

        @Override
        public void visit(ByteBuffer bb, byte[] array2, int arrayIdx, int len) {
            bb.put(array2, arrayIdx, len);
        }
    };

    public ByteBufferArray(long capacity, boolean directByteBuffer) {
        if ((long)this.bufferSize > capacity / 16L) {
            this.bufferSize = (int)this.roundUp(capacity / 16L, 32768L);
        }
        this.bufferCount = (int)(this.roundUp(capacity, this.bufferSize) / (long)this.bufferSize);
        LOG.info((Object)("Allocating buffers total=" + StringUtils.byteDesc((long)capacity) + ", sizePerBuffer=" + StringUtils.byteDesc((long)this.bufferSize) + ", count=" + this.bufferCount + ", direct=" + directByteBuffer));
        this.buffers = new ByteBuffer[this.bufferCount + 1];
        this.locks = new Lock[this.bufferCount + 1];
        for (int i = 0; i <= this.bufferCount; ++i) {
            this.locks[i] = new ReentrantLock();
            this.buffers[i] = i < this.bufferCount ? (directByteBuffer ? ByteBuffer.allocateDirect(this.bufferSize) : ByteBuffer.allocate(this.bufferSize)) : ByteBuffer.allocate(0);
        }
    }

    private long roundUp(long n, long to) {
        return (n + to - 1L) / to * to;
    }

    public int getMultiple(long start2, int len, byte[] dstArray) {
        return this.getMultiple(start2, len, dstArray, 0);
    }

    public int getMultiple(long start2, int len, byte[] dstArray, int dstOffset) {
        this.multiple(start2, len, dstArray, dstOffset, GET_MULTIPLE_VISTOR);
        return len;
    }

    public void putMultiple(long start2, int len, byte[] srcArray) {
        this.putMultiple(start2, len, srcArray, 0);
    }

    public void putMultiple(long start2, int len, byte[] srcArray, int srcOffset) {
        this.multiple(start2, len, srcArray, srcOffset, PUT_MULTIPLE_VISITOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void multiple(long start2, int len, byte[] array2, int arrayOffset, Visitor visitor) {
        assert (len >= 0);
        long end = start2 + (long)len;
        int startBuffer = (int)(start2 / (long)this.bufferSize);
        int startOffset = (int)(start2 % (long)this.bufferSize);
        int endBuffer = (int)(end / (long)this.bufferSize);
        int endOffset = (int)(end % (long)this.bufferSize);
        assert (array2.length >= len + arrayOffset);
        assert (startBuffer >= 0 && startBuffer < this.bufferCount);
        assert (endBuffer >= 0 && endBuffer < this.bufferCount || endBuffer == this.bufferCount && endOffset == 0);
        if (startBuffer >= this.locks.length || startBuffer < 0) {
            String msg = "Failed multiple, start=" + start2 + ",startBuffer=" + startBuffer + ",bufferSize=" + this.bufferSize;
            LOG.error((Object)msg);
            throw new RuntimeException(msg);
        }
        int srcIndex = 0;
        int cnt = -1;
        for (int i = startBuffer; i <= endBuffer; ++i) {
            Lock lock = this.locks[i];
            lock.lock();
            try {
                ByteBuffer bb = this.buffers[i];
                if (i == startBuffer) {
                    cnt = this.bufferSize - startOffset;
                    if (cnt > len) {
                        cnt = len;
                    }
                    bb.limit(startOffset + cnt).position(startOffset);
                } else if (i == endBuffer) {
                    cnt = endOffset;
                    bb.limit(cnt).position(0);
                } else {
                    cnt = this.bufferSize;
                    bb.limit(cnt).position(0);
                }
                visitor.visit(bb, array2, srcIndex + arrayOffset, cnt);
                srcIndex += cnt;
                continue;
            }
            finally {
                lock.unlock();
            }
        }
        assert (srcIndex == len);
    }

    private static interface Visitor {
        public void visit(ByteBuffer var1, byte[] var2, int var3, int var4);
    }
}

