/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;

@PublicAPIClass(maturity=ApiMaturityLevel.STABLE)
public class HoodieDataSourceHelpers {
    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static boolean hasNewCommits(FileSystem fs, String basePath, String commitTimestamp) {
        return HoodieDataSourceHelpers.listCommitsSince(fs, basePath, commitTimestamp).size() > 0;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static List<String> listCommitsSince(FileSystem fs, String basePath, String instantTimestamp) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(fs, basePath);
        return timeline.findInstantsAfter(instantTimestamp, Integer.MAX_VALUE).getInstants().map(HoodieInstant::getTimestamp).collect(Collectors.toList());
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static String latestCommit(FileSystem fs, String basePath) {
        HoodieTimeline timeline = HoodieDataSourceHelpers.allCompletedCommitsCompactions(fs, basePath);
        return timeline.lastInstant().get().getTimestamp();
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    public static HoodieTimeline allCompletedCommitsCompactions(FileSystem fs, String basePath) {
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(fs.getConf(), basePath, true);
        if (metaClient.getTableType().equals((Object)HoodieTableType.MERGE_ON_READ)) {
            return metaClient.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet("commit", "deltacommit", "replacecommit")).filterCompletedInstants();
        }
        return metaClient.getCommitTimeline().filterCompletedInstants();
    }
}

