/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.avro.Conversions;
import org.apache.avro.JsonProperties;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class HoodieAvroUtils {
    private static ThreadLocal<BinaryEncoder> reuseEncoder = ThreadLocal.withInitial(() -> null);
    private static ThreadLocal<BinaryDecoder> reuseDecoder = ThreadLocal.withInitial(() -> null);
    private static String INVALID_AVRO_CHARS_IN_NAMES = "[^A-Za-z0-9_]";
    private static String INVALID_AVRO_FIRST_CHAR_IN_NAMES = "[^A-Za-z_]";
    private static String MASK_FOR_INVALID_CHARS_IN_NAMES = "__";
    public static final Schema METADATA_FIELD_SCHEMA = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.STRING)));
    public static final Schema RECORD_KEY_SCHEMA = HoodieAvroUtils.initRecordKeySchema();

    public static byte[] avroToBytes(GenericRecord record) {
        return HoodieAvroUtils.indexedRecordToBytes(record);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends IndexedRecord> byte[] indexedRecordToBytes(T record) {
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            BinaryEncoder encoder2 = EncoderFactory.get().binaryEncoder((OutputStream)out, reuseEncoder.get());
            reuseEncoder.set(encoder2);
            writer.write(record, (Encoder)encoder2);
            encoder2.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot convert GenericRecord to bytes", e);
        }
    }

    public static byte[] avroToJson(GenericRecord record, boolean pretty) throws IOException {
        GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(record.getSchema(), (OutputStream)out, pretty);
        writer.write((Object)record, (Encoder)jsonEncoder);
        jsonEncoder.flush();
        return out.toByteArray();
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema schema) throws IOException {
        return HoodieAvroUtils.bytesToAvro(bytes, schema, schema);
    }

    public static GenericRecord bytesToAvro(byte[] bytes, Schema writerSchema, Schema readerSchema) throws IOException {
        BinaryDecoder decoder2 = DecoderFactory.get().binaryDecoder(bytes, reuseDecoder.get());
        reuseDecoder.set(decoder2);
        GenericDatumReader reader = new GenericDatumReader(writerSchema, readerSchema);
        return (GenericRecord)reader.read(null, (Decoder)decoder2);
    }

    public static GenericRecord jsonBytesToAvro(byte[] bytes, Schema schema) throws IOException {
        ByteArrayInputStream bio = new ByteArrayInputStream(bytes);
        JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(schema, (InputStream)bio);
        GenericDatumReader reader = new GenericDatumReader(schema);
        return (GenericRecord)reader.read(null, (Decoder)jsonDecoder);
    }

    public static boolean isMetadataField(String fieldName) {
        return "_hoodie_commit_time".equals(fieldName) || "_hoodie_commit_seqno".equals(fieldName) || "_hoodie_record_key".equals(fieldName) || "_hoodie_partition_path".equals(fieldName) || "_hoodie_file_name".equals(fieldName);
    }

    public static Schema createHoodieWriteSchema(Schema originalSchema) {
        return HoodieAvroUtils.addMetadataFields(originalSchema);
    }

    public static Schema createHoodieWriteSchema(String originalSchema) {
        return HoodieAvroUtils.createHoodieWriteSchema(new Schema.Parser().parse(originalSchema));
    }

    public static Schema addMetadataFields(Schema schema) {
        ArrayList<Schema.Field> parentFields = new ArrayList<Schema.Field>();
        Schema.Field commitTimeField = new Schema.Field("_hoodie_commit_time", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field commitSeqnoField = new Schema.Field("_hoodie_commit_seqno", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field partitionPathField = new Schema.Field("_hoodie_partition_path", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field fileNameField = new Schema.Field("_hoodie_file_name", METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        parentFields.add(commitTimeField);
        parentFields.add(commitSeqnoField);
        parentFields.add(recordKeyField);
        parentFields.add(partitionPathField);
        parentFields.add(fileNameField);
        for (Schema.Field field : schema.getFields()) {
            if (HoodieAvroUtils.isMetadataField(field.name())) continue;
            Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal());
            for (Map.Entry prop : field.getObjectProps().entrySet()) {
                newField.addProp((String)prop.getKey(), prop.getValue());
            }
            parentFields.add(newField);
        }
        Schema mergedSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false);
        mergedSchema.setFields(parentFields);
        return mergedSchema;
    }

    public static Schema removeMetadataFields(Schema schema) {
        List filteredFields = schema.getFields().stream().filter(field -> !HoodieRecord.HOODIE_META_COLUMNS.contains(field.name())).map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        Schema filteredSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)false);
        filteredSchema.setFields(filteredFields);
        return filteredSchema;
    }

    public static String addMetadataColumnTypes(String hiveColumnTypes) {
        return "string,string,string,string,string," + hiveColumnTypes;
    }

    private static Schema initRecordKeySchema() {
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", (JsonNode)NullNode.getInstance());
        Schema recordKeySchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        recordKeySchema.setFields(Collections.singletonList(recordKeyField));
        return recordKeySchema;
    }

    public static Schema getRecordKeySchema() {
        return RECORD_KEY_SCHEMA;
    }

    public static Schema getRecordKeyPartitionPathSchema() {
        ArrayList<Schema.Field> toBeAddedFields = new ArrayList<Schema.Field>();
        Schema recordSchema = Schema.createRecord((String)"HoodieRecordKey", (String)"", (String)"", (boolean)false);
        Schema.Field recordKeyField = new Schema.Field("_hoodie_record_key", METADATA_FIELD_SCHEMA, "", (JsonNode)NullNode.getInstance());
        Schema.Field partitionPathField = new Schema.Field("_hoodie_partition_path", METADATA_FIELD_SCHEMA, "", (JsonNode)NullNode.getInstance());
        toBeAddedFields.add(recordKeyField);
        toBeAddedFields.add(partitionPathField);
        recordSchema.setFields(toBeAddedFields);
        return recordSchema;
    }

    public static GenericRecord addHoodieKeyToRecord(GenericRecord record, String recordKey, String partitionPath, String fileName) {
        record.put("_hoodie_file_name", (Object)fileName);
        record.put("_hoodie_partition_path", (Object)partitionPath);
        record.put("_hoodie_record_key", (Object)recordKey);
        return record;
    }

    public static Schema appendNullSchemaFields(Schema schema, List<String> newFieldNames) {
        List newFields = schema.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue())).collect(Collectors.toList());
        for (String newField : newFieldNames) {
            newFields.add(new Schema.Field(newField, METADATA_FIELD_SCHEMA, "", (JsonNode)NullNode.getInstance()));
        }
        Schema newSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        newSchema.setFields(newFields);
        return newSchema;
    }

    public static GenericRecord addCommitMetadataToRecord(GenericRecord record, String instantTime, String commitSeqno) {
        record.put("_hoodie_commit_time", (Object)instantTime);
        record.put("_hoodie_commit_seqno", (Object)commitSeqno);
        return record;
    }

    public static GenericRecord stitchRecords(GenericRecord left, GenericRecord right, Schema stitchedSchema) {
        GenericData.Record result = new GenericData.Record(stitchedSchema);
        for (Schema.Field f : left.getSchema().getFields()) {
            result.put(f.name(), left.get(f.name()));
        }
        for (Schema.Field f : right.getSchema().getFields()) {
            result.put(f.name(), right.get(f.name()));
        }
        return result;
    }

    public static GenericRecord rewriteRecord(GenericRecord oldRecord, Schema newSchema) {
        GenericData.Record newRecord = new GenericData.Record(newSchema);
        boolean isSpecificRecord = oldRecord instanceof SpecificRecordBase;
        for (Schema.Field f : newSchema.getFields()) {
            if (!isSpecificRecord) {
                HoodieAvroUtils.copyOldValueOrSetDefault(oldRecord, (GenericRecord)newRecord, f);
                continue;
            }
            if (HoodieAvroUtils.isMetadataField(f.name())) continue;
            HoodieAvroUtils.copyOldValueOrSetDefault(oldRecord, (GenericRecord)newRecord, f);
        }
        if (!GenericData.get().validate(newSchema, (Object)newRecord)) {
            throw new SchemaCompatibilityException("Unable to validate the rewritten record " + oldRecord + " against schema " + newSchema);
        }
        return newRecord;
    }

    private static void copyOldValueOrSetDefault(GenericRecord oldRecord, GenericRecord newRecord, Schema.Field f) {
        Object fieldValue = oldRecord.get(f.name());
        if (fieldValue == null) {
            if (f.defaultVal() instanceof JsonProperties.Null) {
                newRecord.put(f.name(), null);
            } else {
                newRecord.put(f.name(), f.defaultVal());
            }
        } else {
            newRecord.put(f.name(), fieldValue);
        }
    }

    public static byte[] compress(String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DeflaterOutputStream out = new DeflaterOutputStream(baos);
            ((OutputStream)out).write(text.getBytes(StandardCharsets.UTF_8));
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while compressing text " + text, e);
        }
        return baos.toByteArray();
    }

    public static String decompress(byte[] bytes) {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)in).read(buffer)) > 0) {
                baos.write(buffer, 0, len);
            }
            return new String(baos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException while decompressing text", e);
        }
    }

    public static Schema generateProjectionSchema(Schema originalSchema, List<String> fieldNames) {
        Map<String, Schema.Field> schemaFieldsMap = originalSchema.getFields().stream().map(r -> Pair.of(r.name().toLowerCase(), r)).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fn : fieldNames) {
            Schema.Field field = schemaFieldsMap.get(fn.toLowerCase());
            if (field == null) {
                throw new HoodieException("Field " + fn + " not found in log schema. Query cannot proceed! Derived Schema Fields: " + new ArrayList<String>(schemaFieldsMap.keySet()));
            }
            projectedFields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue()));
        }
        Schema projectedSchema = Schema.createRecord((String)originalSchema.getName(), (String)originalSchema.getDoc(), (String)originalSchema.getNamespace(), (boolean)originalSchema.isError());
        projectedSchema.setFields(projectedFields);
        return projectedSchema;
    }

    public static String getNestedFieldValAsString(GenericRecord record, String fieldName, boolean returnNullIfNotFound) {
        Object obj = HoodieAvroUtils.getNestedFieldVal(record, fieldName, returnNullIfNotFound);
        return StringUtils.objToString(obj);
    }

    public static Object getNestedFieldVal(GenericRecord record, String fieldName, boolean returnNullIfNotFound) {
        String part;
        Object val;
        int i;
        String[] parts = fieldName.split("\\.");
        GenericRecord valueNode = record;
        for (i = 0; i < parts.length && (val = valueNode.get(part = parts[i])) != null; ++i) {
            if (i == parts.length - 1) {
                Schema fieldSchema = valueNode.getSchema().getField(part).schema();
                return HoodieAvroUtils.convertValueForSpecificDataTypes(fieldSchema, val);
            }
            if (!(val instanceof GenericRecord)) {
                throw new HoodieException("Cannot find a record at part value :" + part);
            }
            valueNode = (GenericRecord)val;
        }
        if (returnNullIfNotFound) {
            return null;
        }
        if (valueNode.getSchema().getField(parts[i]) == null) {
            throw new HoodieException(fieldName + "(Part -" + parts[i] + ") field not found in record. Acceptable fields were :" + valueNode.getSchema().getFields().stream().map(Schema.Field::name).collect(Collectors.toList()));
        }
        throw new HoodieException("The value of " + parts[i] + " can not be null");
    }

    public static Object convertValueForSpecificDataTypes(Schema fieldSchema, Object fieldValue) {
        if (fieldSchema == null) {
            return fieldValue;
        }
        if (fieldSchema.getType() == Schema.Type.UNION) {
            for (Schema schema : fieldSchema.getTypes()) {
                if (schema.getType() == Schema.Type.NULL) continue;
                return HoodieAvroUtils.convertValueForAvroLogicalTypes(schema, fieldValue);
            }
        }
        return HoodieAvroUtils.convertValueForAvroLogicalTypes(fieldSchema, fieldValue);
    }

    private static Object convertValueForAvroLogicalTypes(Schema fieldSchema, Object fieldValue) {
        if (fieldSchema.getLogicalType() == LogicalTypes.date()) {
            return LocalDate.ofEpochDay(Long.parseLong(fieldValue.toString()));
        }
        if (fieldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
            LogicalTypes.Decimal dc = (LogicalTypes.Decimal)fieldSchema.getLogicalType();
            Conversions.DecimalConversion decimalConversion = new Conversions.DecimalConversion();
            if (fieldSchema.getType() == Schema.Type.FIXED) {
                return decimalConversion.fromFixed((GenericFixed)fieldValue, fieldSchema, (LogicalType)LogicalTypes.decimal((int)dc.getPrecision(), (int)dc.getScale()));
            }
            if (fieldSchema.getType() == Schema.Type.BYTES) {
                return decimalConversion.fromBytes((ByteBuffer)fieldValue, fieldSchema, (LogicalType)LogicalTypes.decimal((int)dc.getPrecision(), (int)dc.getScale()));
            }
        }
        return fieldValue;
    }

    public static Schema getNullSchema() {
        return Schema.create((Schema.Type)Schema.Type.NULL);
    }

    public static String sanitizeName(String name) {
        if (name.substring(0, 1).matches(INVALID_AVRO_FIRST_CHAR_IN_NAMES)) {
            name = name.replaceFirst(INVALID_AVRO_FIRST_CHAR_IN_NAMES, MASK_FOR_INVALID_CHARS_IN_NAMES);
        }
        return name.replaceAll(INVALID_AVRO_CHARS_IN_NAMES, MASK_FOR_INVALID_CHARS_IN_NAMES);
    }
}

