/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import io.hops.hudi.com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.AbstractHoodieWriteClient;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndex;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.compact.SparkCompactHelpers;
import org.apache.hudi.table.upgrade.SparkUpgradeDowngrade;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;

public class SparkRDDWriteClient<T extends HoodieRecordPayload>
extends AbstractHoodieWriteClient<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkRDDWriteClient.class);

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        super(context, clientConfig);
    }

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending) {
        super(context, writeConfig, rollbackPending);
    }

    public SparkRDDWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, rollbackPending, timelineService);
    }

    public static SparkConf registerClasses(SparkConf conf) {
        conf.registerKryoClasses(new Class[]{HoodieWriteConfig.class, HoodieRecord.class, HoodieKey.class});
        return conf;
    }

    @Override
    protected HoodieIndex<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> createIndex(HoodieWriteConfig writeConfig) {
        return SparkHoodieIndex.createIndex(this.config);
    }

    @Override
    public boolean commit(String instantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds) {
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        return this.commitStats(instantTime, writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds);
    }

    @Override
    protected HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> createTable(HoodieWriteConfig config, Configuration hadoopConf) {
        return HoodieSparkTable.create(config, this.context);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> filterExists(JavaRDD<HoodieRecord<T>> hoodieRecords) {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        JavaRDD<HoodieRecord<T>> recordsWithLocation = this.getIndex().tagLocation(hoodieRecords, this.context, table);
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.filter((Function & Serializable)v1 -> !v1.isCurrentLocationKnown());
    }

    @Override
    public void bootstrap(Option<Map<String, String>> extraMetadata) {
        if (this.rollbackPending) {
            this.rollBackInflightBootstrap();
        }
        this.getTableAndInitCtx(WriteOperationType.UPSERT, "00000000000001").bootstrap(this.context, extraMetadata);
    }

    @Override
    public JavaRDD<WriteStatus> upsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.UPSERT, instantTime);
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.upsert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", result.getIndexLookupDuration().get().toMillis());
        }
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> upsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.UPSERT_PREPPED, instantTime);
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.upsertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insert(this.context, instantTime, records);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> insertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT_PREPPED, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insertPrepped(this.context, instantTime, preppedRecords);
        return this.postWrite(result, instantTime, table);
    }

    public HoodieWriteResult insertOverwrite(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT_OVERWRITE, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insertOverwrite(this.context, instantTime, records);
        return new HoodieWriteResult(this.postWrite(result, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    public HoodieWriteResult insertOverwriteTable(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.INSERT_OVERWRITE_TABLE, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_OVERWRITE_TABLE);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.insertOverwriteTable(this.context, instantTime, records);
        return new HoodieWriteResult(this.postWrite(result, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime) {
        return this.bulkInsert(records, instantTime, Option.empty());
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsert(JavaRDD<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> userDefinedBulkInsertPartitioner) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.BULK_INSERT, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.bulkInsert(this.context, instantTime, records, userDefinedBulkInsertPartitioner);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> bulkInsertPreppedRecords(JavaRDD<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> bulkInsertPartitioner) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.BULK_INSERT_PREPPED, instantTime);
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.bulkInsertPrepped(this.context, instantTime, preppedRecords, bulkInsertPartitioner);
        return this.postWrite(result, instantTime, table);
    }

    @Override
    public JavaRDD<WriteStatus> delete(JavaRDD<HoodieKey> keys2, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.DELETE, instantTime);
        this.preWrite(instantTime, WriteOperationType.DELETE);
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = table.delete(this.context, instantTime, keys2);
        return this.postWrite(result, instantTime, table);
    }

    public HoodieWriteResult deletePartitions(List<String> partitions, String instantTime) {
        HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table = this.getTableAndInitCtx(WriteOperationType.DELETE_PARTITION, instantTime);
        this.preWrite(instantTime, WriteOperationType.DELETE_PARTITION);
        HoodieWriteMetadata result = table.deletePartitions(this.context, instantTime, partitions);
        return new HoodieWriteResult(this.postWrite((HoodieWriteMetadata<JavaRDD<WriteStatus>>)result, instantTime, table), result.getPartitionToReplaceFileIds());
    }

    @Override
    protected JavaRDD<WriteStatus> postWrite(HoodieWriteMetadata<JavaRDD<WriteStatus>> result, String instantTime, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> hoodieTable) {
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics(this.getOperationType().name(), result.getIndexUpdateDuration().get().toMillis());
        }
        if (result.isCommitted()) {
            if (result.getFinalizeDuration().isPresent()) {
                this.metrics.updateFinalizeWriteMetrics(result.getFinalizeDuration().get().toMillis(), result.getWriteStats().get().size());
            }
            this.postCommit(hoodieTable, result.getCommitMetadata().get(), instantTime, Option.empty());
            this.emitCommitMetrics(instantTime, result.getCommitMetadata().get(), hoodieTable.getMetaClient().getCommitActionType());
        }
        return result.getWriteStatuses();
    }

    @Override
    public void commitCompaction(String compactionInstantTime, JavaRDD<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata) throws IOException {
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        HoodieCommitMetadata metadata = SparkCompactHelpers.newInstance().createCompactionMetadata(table, compactionInstantTime, writeStatuses, this.config.getSchema());
        extraMetadata.ifPresent(m -> m.forEach(metadata::addMetadata));
        this.completeCompaction(metadata, writeStatuses, (HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>>)table, compactionInstantTime);
    }

    @Override
    protected void completeCompaction(HoodieCommitMetadata metadata, JavaRDD<WriteStatus> writeStatuses, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String compactionCommitTime) {
        this.context.setJobStatus(this.getClass().getSimpleName(), "Collect compaction write status and commit compaction");
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        this.finalizeWrite(table, compactionCommitTime, writeStats);
        LOG.info((Object)("Committing Compaction " + compactionCommitTime + ". Finished with result " + metadata));
        SparkCompactHelpers.newInstance().completeInflightCompaction(table, compactionCommitTime, metadata);
        if (this.compactionTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.compactionTimer.stop());
            try {
                this.metrics.updateCommitMetrics(HoodieActiveTimeline.COMMIT_FORMATTER.parse(compactionCommitTime).getTime(), durationInMs, metadata, "compaction");
            }
            catch (ParseException e) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + compactionCommitTime, e);
            }
        }
        LOG.info((Object)("Compacted successfully on commit " + compactionCommitTime));
    }

    @Override
    protected JavaRDD<WriteStatus> compact(String compactionInstantTime, boolean shouldComplete) {
        HoodieInstant inflightInstant;
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        HoodieTimeline pendingCompactionTimeline = table.getActiveTimeline().filterPendingCompactionTimeline();
        if (pendingCompactionTimeline.containsInstant(inflightInstant = HoodieTimeline.getCompactionInflightInstant(compactionInstantTime))) {
            this.rollbackInflightCompaction(inflightInstant, table);
            table.getMetaClient().reloadActiveTimeline();
        }
        this.compactionTimer = this.metrics.getCompactionCtx();
        HoodieWriteMetadata compactionMetadata = table.compact(this.context, compactionInstantTime);
        JavaRDD statuses = (JavaRDD)compactionMetadata.getWriteStatuses();
        if (shouldComplete && compactionMetadata.getCommitMetadata().isPresent()) {
            this.completeCompaction(compactionMetadata.getCommitMetadata().get(), (JavaRDD<WriteStatus>)statuses, (HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>>)table, compactionInstantTime);
        }
        return statuses;
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> cluster(String clusteringInstant, boolean shouldComplete) {
        HoodieInstant inflightInstant;
        HoodieSparkTable table = HoodieSparkTable.create(this.config, this.context);
        HoodieTimeline pendingClusteringTimeline = table.getActiveTimeline().filterPendingReplaceTimeline();
        if (pendingClusteringTimeline.containsInstant(inflightInstant = HoodieTimeline.getReplaceCommitInflightInstant(clusteringInstant))) {
            this.rollbackInflightClustering(inflightInstant, table);
            table.getMetaClient().reloadActiveTimeline();
        }
        this.clusteringTimer = this.metrics.getClusteringCtx();
        LOG.info((Object)("Starting clustering at " + clusteringInstant));
        HoodieWriteMetadata<JavaRDD<WriteStatus>> clusteringMetadata = table.cluster(this.context, clusteringInstant);
        JavaRDD statuses = (JavaRDD)clusteringMetadata.getWriteStatuses();
        if (shouldComplete && clusteringMetadata.getCommitMetadata().isPresent()) {
            this.completeClustering((HoodieReplaceCommitMetadata)clusteringMetadata.getCommitMetadata().get(), (JavaRDD<WriteStatus>)statuses, table, clusteringInstant);
        }
        return clusteringMetadata;
    }

    protected void completeClustering(HoodieReplaceCommitMetadata metadata, JavaRDD<WriteStatus> writeStatuses, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String clusteringCommitTime) {
        List writeStats = writeStatuses.map(WriteStatus::getStat).collect();
        if (!writeStatuses.filter(WriteStatus::hasErrors).isEmpty()) {
            throw new HoodieClusteringException("Clustering failed to write to files:" + writeStatuses.filter(WriteStatus::hasErrors).map(WriteStatus::getFileId).collect());
        }
        this.finalizeWrite(table, clusteringCommitTime, writeStats);
        try {
            LOG.info((Object)("Committing Clustering " + clusteringCommitTime + ". Finished with result " + metadata));
            table.getActiveTimeline().transitionReplaceInflightToComplete(HoodieTimeline.getReplaceCommitInflightInstant(clusteringCommitTime), Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException e) {
            throw new HoodieClusteringException("unable to transition clustering inflight to complete: " + clusteringCommitTime, e);
        }
        if (this.clusteringTimer != null) {
            long durationInMs = this.metrics.getDurationInMs(this.clusteringTimer.stop());
            try {
                this.metrics.updateCommitMetrics(HoodieActiveTimeline.COMMIT_FORMATTER.parse(clusteringCommitTime).getTime(), durationInMs, metadata, "replacecommit");
            }
            catch (ParseException e) {
                throw new HoodieCommitException("Commit time is not of valid format. Failed to commit compaction " + this.config.getBasePath() + " at time " + clusteringCommitTime, e);
            }
        }
        LOG.info((Object)("Clustering successfully on commit " + clusteringCommitTime));
    }

    @Override
    protected HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> getTableAndInitCtx(WriteOperationType operationType, String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        new SparkUpgradeDowngrade(metaClient, this.config, this.context).run(metaClient, HoodieTableVersion.current(), this.config, this.context, instantTime);
        return this.getTableAndInitCtx(metaClient, operationType);
    }

    private HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> getTableAndInitCtx(HoodieTableMetaClient metaClient, WriteOperationType operationType) {
        HoodieSparkTable table;
        if (operationType == WriteOperationType.DELETE) {
            this.setWriteSchemaForDeletes(metaClient);
        }
        this.writeTimer = (table = HoodieSparkTable.create(this.config, (HoodieSparkEngineContext)this.context, metaClient)).getMetaClient().getCommitActionType().equals("commit") ? this.metrics.getCommitCtx() : this.metrics.getDeltaCommitCtx();
        return table;
    }

    @Override
    public void syncTableMetadata() {
        try (HoodieTableMetadataWriter writer = SparkHoodieBackedTableMetadataWriter.create(this.hadoopConf, this.config, this.context);){
            LOG.info((Object)"Successfully synced to metadata table");
        }
        catch (Exception e) {
            throw new HoodieMetadataException("Error syncing to metadata table.", e);
        }
    }

    @Override
    protected void initWrapperFSMetrics() {
        if (this.config.isMetricsOn()) {
            Registry registryMeta;
            Registry registry;
            JavaSparkContext jsc = ((HoodieSparkEngineContext)this.context).getJavaSparkContext();
            if (this.config.isExecutorMetricsEnabled()) {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName(), DistributedRegistry.class.getName());
                ((DistributedRegistry)registry).register(jsc);
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder", DistributedRegistry.class.getName());
                ((DistributedRegistry)registryMeta).register(jsc);
            } else {
                registry = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName());
                registryMeta = Registry.getRegistry(HoodieWrapperFileSystem.class.getSimpleName() + "MetaFolder");
            }
            HoodieWrapperFileSystem.setMetricsRegistry(registry, registryMeta);
        }
    }
}

