/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.update.strategy;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.exception.HoodieClusteringUpdateException;
import org.apache.hudi.table.action.cluster.strategy.UpdateStrategy;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;

public class SparkRejectUpdateStrategy<T extends HoodieRecordPayload<T>>
extends UpdateStrategy<T, JavaRDD<HoodieRecord<T>>> {
    private static final Logger LOG = LogManager.getLogger(SparkRejectUpdateStrategy.class);

    public SparkRejectUpdateStrategy(HoodieSparkEngineContext engineContext, HashSet<HoodieFileGroupId> fileGroupsInPendingClustering) {
        super(engineContext, fileGroupsInPendingClustering);
    }

    private List<HoodieFileGroupId> getGroupIdsWithUpdate(JavaRDD<HoodieRecord<T>> inputRecords) {
        List fileGroupIdsWithUpdates = inputRecords.filter((Function & Serializable)record -> record.getCurrentLocation() != null).map((Function & Serializable)record -> new HoodieFileGroupId(record.getPartitionPath(), record.getCurrentLocation().getFileId())).distinct().collect();
        return fileGroupIdsWithUpdates;
    }

    @Override
    public JavaRDD<HoodieRecord<T>> handleUpdate(JavaRDD<HoodieRecord<T>> taggedRecordsRDD) {
        List<HoodieFileGroupId> fileGroupIdsWithRecordUpdate = this.getGroupIdsWithUpdate(taggedRecordsRDD);
        fileGroupIdsWithRecordUpdate.forEach(fileGroupIdWithRecordUpdate -> {
            if (this.fileGroupsInPendingClustering.contains(fileGroupIdWithRecordUpdate)) {
                String msg = String.format("Not allowed to update the clustering file group %s. For pending clustering operations, we are not going to support update for now.", fileGroupIdWithRecordUpdate.toString());
                LOG.error((Object)msg);
                throw new HoodieClusteringUpdateException(msg);
            }
        });
        return taggedRecordsRDD;
    }
}

