/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.bootstrap;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hudi.avro.model.HoodieFSPermission;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.avro.model.HoodiePath;
import org.apache.hudi.exception.HoodieIOException;

public class FileStatusUtils {
    public static Path toPath(HoodiePath path) {
        if (null == path) {
            return null;
        }
        return new Path(path.getUri());
    }

    public static HoodiePath fromPath(Path path) {
        if (null == path) {
            return null;
        }
        return HoodiePath.newBuilder().setUri(path.toString()).build();
    }

    public static FsPermission toFSPermission(HoodieFSPermission fsPermission) {
        if (null == fsPermission) {
            return null;
        }
        FsAction userAction = fsPermission.getUserAction() != null ? FsAction.valueOf((String)fsPermission.getUserAction()) : null;
        FsAction grpAction = fsPermission.getGroupAction() != null ? FsAction.valueOf((String)fsPermission.getGroupAction()) : null;
        FsAction otherAction = fsPermission.getOtherAction() != null ? FsAction.valueOf((String)fsPermission.getOtherAction()) : null;
        boolean stickyBit = fsPermission.getStickyBit() != null ? fsPermission.getStickyBit() : false;
        return new FsPermission(userAction, grpAction, otherAction, stickyBit);
    }

    public static HoodieFSPermission fromFSPermission(FsPermission fsPermission) {
        if (null == fsPermission) {
            return null;
        }
        String userAction = fsPermission.getUserAction() != null ? fsPermission.getUserAction().name() : null;
        String grpAction = fsPermission.getGroupAction() != null ? fsPermission.getGroupAction().name() : null;
        String otherAction = fsPermission.getOtherAction() != null ? fsPermission.getOtherAction().name() : null;
        return HoodieFSPermission.newBuilder().setUserAction(userAction).setGroupAction(grpAction).setOtherAction(otherAction).setStickyBit(fsPermission.getStickyBit()).build();
    }

    public static FileStatus toFileStatus(HoodieFileStatus fileStatus) {
        if (null == fileStatus) {
            return null;
        }
        return new FileStatus(fileStatus.getLength().longValue(), fileStatus.getIsDir() == null ? false : fileStatus.getIsDir(), fileStatus.getBlockReplication().intValue(), fileStatus.getBlockSize().longValue(), fileStatus.getModificationTime().longValue(), fileStatus.getAccessTime().longValue(), FileStatusUtils.toFSPermission(fileStatus.getPermission()), fileStatus.getOwner(), fileStatus.getGroup(), FileStatusUtils.toPath(fileStatus.getSymlink()), FileStatusUtils.toPath(fileStatus.getPath()));
    }

    public static HoodieFileStatus fromFileStatus(FileStatus fileStatus) {
        if (null == fileStatus) {
            return null;
        }
        HoodieFileStatus fStatus = new HoodieFileStatus();
        try {
            fStatus.setPath(FileStatusUtils.fromPath(fileStatus.getPath()));
            fStatus.setLength(fileStatus.getLen());
            fStatus.setIsDir(fileStatus.isDirectory());
            fStatus.setBlockReplication(Integer.valueOf(fileStatus.getReplication()));
            fStatus.setBlockSize(fileStatus.getBlockSize());
            fStatus.setModificationTime(fileStatus.getModificationTime());
            fStatus.setAccessTime(fileStatus.getModificationTime());
            fStatus.setSymlink(fileStatus.isSymlink() ? FileStatusUtils.fromPath(fileStatus.getSymlink()) : null);
            FileStatusUtils.safeReadAndSetMetadata(fStatus, fileStatus);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        return fStatus;
    }

    private static void safeReadAndSetMetadata(HoodieFileStatus fStatus, FileStatus fileStatus) {
        try {
            fStatus.setOwner(fileStatus.getOwner());
            fStatus.setGroup(fileStatus.getGroup());
            fStatus.setPermission(FileStatusUtils.fromFSPermission(fileStatus.getPermission()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

