/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.IOException;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;

public class RDDCustomColumnsSortPartitioner<T extends HoodieRecordPayload>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final String[] sortColumnNames;
    private final SerializableSchema serializableSchema;

    public RDDCustomColumnsSortPartitioner(String[] columnNames, Schema schema) {
        this.sortColumnNames = columnNames;
        this.serializableSchema = new SerializableSchema(schema);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        String[] sortColumns = this.sortColumnNames;
        SerializableSchema schema = this.serializableSchema;
        return records.sortBy((Function & Serializable)record -> RDDCustomColumnsSortPartitioner.getRecordSortColumnValues(record, sortColumns, schema), true, outputSparkPartitions);
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }

    private static Object getRecordSortColumnValues(HoodieRecord<? extends HoodieRecordPayload> record, String[] sortColumns, SerializableSchema schema) {
        try {
            GenericRecord genericRecord = (GenericRecord)record.getData().getInsertValue(schema.get()).get();
            if (sortColumns.length == 1) {
                return HoodieAvroUtils.getNestedFieldVal(genericRecord, sortColumns[0], true);
            }
            StringBuilder sb = new StringBuilder();
            for (String col : sortColumns) {
                sb.append(HoodieAvroUtils.getNestedFieldValAsString(genericRecord, col, true));
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new HoodieIOException("Unable to read record with key:" + record.getKey(), e);
        }
    }
}

