/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.realtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hudi.hadoop.realtime.RealtimeSplit;

public class HoodieRealtimeFileSplit
extends FileSplit
implements RealtimeSplit {
    private List<String> deltaLogPaths;
    private String maxCommitTime;
    private String basePath;

    public HoodieRealtimeFileSplit() {
    }

    public HoodieRealtimeFileSplit(FileSplit baseSplit, String basePath, List<String> deltaLogPaths, String maxCommitTime) throws IOException {
        super(baseSplit.getPath(), baseSplit.getStart(), baseSplit.getLength(), baseSplit.getLocations());
        this.deltaLogPaths = deltaLogPaths;
        this.maxCommitTime = maxCommitTime;
        this.basePath = basePath;
    }

    @Override
    public List<String> getDeltaLogPaths() {
        return this.deltaLogPaths;
    }

    @Override
    public String getMaxCommitTime() {
        return this.maxCommitTime;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setDeltaLogPaths(List<String> deltaLogPaths) {
        this.deltaLogPaths = deltaLogPaths;
    }

    @Override
    public void setMaxCommitTime(String maxCommitTime) {
        this.maxCommitTime = maxCommitTime;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        this.writeToOutput(out);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.readFromInput(in);
    }

    public String toString() {
        return "HoodieRealtimeFileSplit{DataPath=" + this.getPath() + ", deltaLogPaths=" + this.deltaLogPaths + ", maxCommitTime='" + this.maxCommitTime + '\'' + ", basePath='" + this.basePath + '\'' + '}';
    }
}

