/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.Collections;
import java.util.List;
import org.apache.hudi.hive.PartitionValueExtractor;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SlashEncodedHourPartitionValueExtractor
implements PartitionValueExtractor {
    private static final long serialVersionUID = 1L;
    private transient DateTimeFormatter dtfOut = DateTimeFormat.forPattern((String)"yyyy-MM-dd-HH");

    private DateTimeFormatter getDtfOut() {
        if (this.dtfOut == null) {
            this.dtfOut = DateTimeFormat.forPattern((String)"yyyy-MM-dd-HH");
        }
        return this.dtfOut;
    }

    @Override
    public List<String> extractPartitionValuesInPath(String partitionPath) {
        String[] splits = partitionPath.split("/");
        if (splits.length != 4) {
            throw new IllegalArgumentException("Partition path " + partitionPath + " is not in the form  yyyy/mm/dd/HH");
        }
        int year = Integer.parseInt(splits[0].contains("=") ? splits[0].split("=")[1] : splits[0]);
        int mm = Integer.parseInt(splits[1].contains("=") ? splits[1].split("=")[1] : splits[1]);
        int dd = Integer.parseInt(splits[2].contains("=") ? splits[2].split("=")[1] : splits[2]);
        int hh = Integer.parseInt(splits[3].contains("=") ? splits[3].split("=")[1] : splits[3]);
        DateTime dateTime = new DateTime(year, mm, dd, hh, 0);
        return Collections.singletonList(this.getDtfOut().print((ReadableInstant)dateTime));
    }
}

