/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedGlobalIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedGlobalIndexFileFilter;
import org.apache.hudi.index.bloom.SparkHoodieBloomIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.Optional;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class SparkHoodieGlobalBloomIndex<T extends HoodieRecordPayload>
extends SparkHoodieBloomIndex<T> {
    public SparkHoodieGlobalBloomIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    List<Tuple2<String, BloomIndexFileInfo>> loadInvolvedFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List<String> allPartitionPaths = FSUtils.getAllPartitionPaths(context, this.config.getMetadataConfig(), metaClient.getBasePath());
        return super.loadInvolvedFiles(allPartitionPaths, context, hoodieTable);
    }

    @Override
    JavaRDD<Tuple2<String, HoodieKey>> explodeRecordRDDWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, JavaPairRDD<String, String> partitionRecordKeyPairRDD) {
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedGlobalIndexFileFilter(partitionToFileIndexInfo) : new ListBasedGlobalIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairRDD.map((Function & Serializable)partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair._2();
            String partitionPath = (String)partitionRecordKeyPair._1();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new Tuple2(partitionFileIdPair.getRight(), (Object)new HoodieKey(recordKey, (String)partitionFileIdPair.getLeft()))).collect(Collectors.toList());
        }).flatMap(List::iterator);
    }

    @Override
    protected JavaRDD<HoodieRecord<T>> tagLocationBacktoRecords(JavaPairRDD<HoodieKey, HoodieRecordLocation> keyLocationPairRDD, JavaRDD<HoodieRecord<T>> recordRDD) {
        JavaPairRDD incomingRowKeyRecordPairRDD = recordRDD.mapToPair((PairFunction & Serializable)record -> new Tuple2((Object)record.getRecordKey(), record));
        JavaPairRDD existingRecordKeyToRecordLocationHoodieKeyMap = keyLocationPairRDD.mapToPair((PairFunction & Serializable)p -> new Tuple2((Object)((HoodieKey)p._1).getRecordKey(), (Object)new Tuple2(p._2, p._1)));
        return incomingRowKeyRecordPairRDD.leftOuterJoin(existingRecordKeyToRecordLocationHoodieKeyMap).values().flatMap((FlatMapFunction & Serializable)record -> {
            HoodieRecord hoodieRecord = (HoodieRecord)record._1;
            Optional recordLocationHoodieKeyPair = (Optional)record._2;
            if (recordLocationHoodieKeyPair.isPresent()) {
                if (this.config.getBloomIndexUpdatePartitionPath() && !((HoodieKey)((Tuple2)recordLocationHoodieKeyPair.get())._2).getPartitionPath().equals(hoodieRecord.getPartitionPath())) {
                    HoodieRecord<EmptyHoodieRecordPayload> deleteRecord = new HoodieRecord<EmptyHoodieRecordPayload>((HoodieKey)((Tuple2)recordLocationHoodieKeyPair.get())._2, new EmptyHoodieRecordPayload());
                    deleteRecord.setCurrentLocation((HoodieRecordLocation)((Tuple2)recordLocationHoodieKeyPair.get())._1());
                    deleteRecord.seal();
                    HoodieRecord insertRecord = HoodieIndexUtils.getTaggedRecord(hoodieRecord, Option.empty());
                    return Arrays.asList(deleteRecord, insertRecord).iterator();
                }
                return Collections.singletonList(HoodieIndexUtils.getTaggedRecord(new HoodieRecord((HoodieKey)((Tuple2)recordLocationHoodieKeyPair.get())._2, hoodieRecord.getData()), Option.ofNullable(((Tuple2)recordLocationHoodieKeyPair.get())._1))).iterator();
            }
            return Collections.singletonList(HoodieIndexUtils.getTaggedRecord(hoodieRecord, Option.empty())).iterator();
        });
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

