/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;

public class HoodieParquetReader<R extends IndexedRecord>
implements HoodieFileReader {
    private Path path;
    private Configuration conf;

    public HoodieParquetReader(Configuration configuration, Path path) {
        this.conf = configuration;
        this.path = path;
    }

    @Override
    public String[] readMinMaxRecordKeys() {
        return ParquetUtils.readMinMaxRecordKeys(this.conf, this.path);
    }

    @Override
    public BloomFilter readBloomFilter() {
        return ParquetUtils.readBloomFilterFromParquetMetadata(this.conf, this.path);
    }

    public Set<String> filterRowKeys(Set candidateRowKeys) {
        return ParquetUtils.filterParquetRowKeys(this.conf, this.path, candidateRowKeys);
    }

    @Override
    public Iterator<R> getRecordIterator(Schema schema) throws IOException {
        AvroReadSupport.setAvroReadSchema(this.conf, schema);
        ParquetReader reader = AvroParquetReader.builder(this.path).withConf(this.conf).build();
        return new ParquetReaderIterator(reader);
    }

    @Override
    public Schema getSchema() {
        return ParquetUtils.readAvroSchema(this.conf, this.path);
    }

    @Override
    public void close() {
    }

    @Override
    public long getTotalRecords() {
        return ParquetUtils.getRowCount(this.conf, this.path);
    }
}

