/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.spark.sql.Row;

public class ComplexKeyGenerator
extends BuiltinKeyGenerator {
    private final ComplexAvroKeyGenerator complexAvroKeyGenerator;

    public ComplexKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = Arrays.stream(props.getString("hoodie.datasource.write.recordkey.field").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.partitionPathFields = Arrays.stream(props.getString("hoodie.datasource.write.partitionpath.field").split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.complexAvroKeyGenerator = new ComplexAvroKeyGenerator(props);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.complexAvroKeyGenerator.getRecordKey(record);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.complexAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldPositionMapIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeyPositions, true);
    }

    @Override
    public String getPartitionPath(Row row) {
        this.buildFieldPositionMapIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getPartitionPathFromRow(row, this.getPartitionPathFields(), this.hiveStylePartitioning, this.partitionPathPositions);
    }
}

