/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.GlobalAvroDeleteKeyGenerator;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.spark.sql.Row;

public class GlobalDeleteKeyGenerator
extends BuiltinKeyGenerator {
    private final GlobalAvroDeleteKeyGenerator globalAvroDeleteKeyGenerator;

    public GlobalDeleteKeyGenerator(TypedProperties config) {
        super(config);
        this.recordKeyFields = Arrays.asList(config.getString("hoodie.datasource.write.recordkey.field").split(","));
        this.globalAvroDeleteKeyGenerator = new GlobalAvroDeleteKeyGenerator(config);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.globalAvroDeleteKeyGenerator.getRecordKey(record);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.globalAvroDeleteKeyGenerator.getPartitionPath(record);
    }

    @Override
    public List<String> getPartitionPathFields() {
        return new ArrayList<String>();
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldPositionMapIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeyPositions, true);
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.globalAvroDeleteKeyGenerator.getEmptyPartition();
    }
}

