/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.Collections;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;

public class SimpleAvroKeyGenerator
extends BaseKeyGenerator {
    public SimpleAvroKeyGenerator(TypedProperties props) {
        this(props, props.getString("hoodie.datasource.write.recordkey.field"), props.getString("hoodie.datasource.write.partitionpath.field"));
    }

    SimpleAvroKeyGenerator(TypedProperties props, String partitionPathField) {
        this(props, null, partitionPathField);
    }

    SimpleAvroKeyGenerator(TypedProperties props, String recordKeyField, String partitionPathField) {
        super(props);
        this.recordKeyFields = recordKeyField == null ? Collections.emptyList() : Collections.singletonList(recordKeyField);
        this.partitionPathFields = Collections.singletonList(partitionPathField);
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return KeyGenUtils.getRecordKey(record, this.getRecordKeyFields().get(0));
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return KeyGenUtils.getPartitionPath(record, this.getPartitionPathFields().get(0), this.hiveStylePartitioning, this.encodePartitionPath);
    }
}

