/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.RowKeyGeneratorHelper;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator;
import org.apache.spark.sql.Row;

public class TimestampBasedKeyGenerator
extends SimpleKeyGenerator {
    private final TimestampBasedAvroKeyGenerator timestampBasedAvroKeyGenerator;

    public TimestampBasedKeyGenerator(TypedProperties config) throws IOException {
        this(config, config.getString("hoodie.datasource.write.recordkey.field"), config.getString("hoodie.datasource.write.partitionpath.field"));
    }

    TimestampBasedKeyGenerator(TypedProperties config, String partitionPathField) throws IOException {
        this(config, null, partitionPathField);
    }

    TimestampBasedKeyGenerator(TypedProperties config, String recordKeyField, String partitionPathField) throws IOException {
        super(config, recordKeyField, partitionPathField);
        this.timestampBasedAvroKeyGenerator = new TimestampBasedAvroKeyGenerator(config, recordKeyField, partitionPathField);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.timestampBasedAvroKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        this.buildFieldPositionMapIfNeeded(row.schema());
        return RowKeyGeneratorHelper.getRecordKeyFromRow(row, this.getRecordKeyFields(), this.recordKeyPositions, false);
    }

    @Override
    public String getPartitionPath(Row row) {
        Object fieldVal = null;
        this.buildFieldPositionMapIfNeeded(row.schema());
        Object partitionPathFieldVal = RowKeyGeneratorHelper.getNestedFieldVal(row, (List)this.partitionPathPositions.get(this.getPartitionPathFields().get(0)));
        try {
            fieldVal = partitionPathFieldVal == null || partitionPathFieldVal.toString().contains("default") || partitionPathFieldVal.toString().contains("__null__") || partitionPathFieldVal.toString().contains("__empty__") ? this.timestampBasedAvroKeyGenerator.getDefaultPartitionVal() : partitionPathFieldVal;
            return this.timestampBasedAvroKeyGenerator.getPartitionPath(fieldVal);
        }
        catch (Exception e) {
            throw new HoodieKeyGeneratorException("Unable to parse input partition field :" + fieldVal, e);
        }
    }
}

