/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import io.hops.hudi.com.codahale.metrics.jmx.JmxReporter;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Objects;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;

public class JmxReporterServer {
    private JMXConnectorServer connector;
    private Registry rmiRegistry;
    private JmxReporter reporter;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    protected JmxReporterServer(MetricRegistry registry, String host, int port, MBeanServer mBeanServer) {
        String serviceUrl = "service:jmx:rmi://localhost:" + port + "/jndi/rmi://" + host + ":" + port + "/jmxrmi";
        try {
            JMXServiceURL url = new JMXServiceURL(serviceUrl);
            this.connector = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mBeanServer);
            this.rmiRegistry = LocateRegistry.createRegistry(port);
            this.reporter = JmxReporter.forRegistry((MetricRegistry)registry).registerWith(mBeanServer).build();
        }
        catch (Exception e) {
            throw new HoodieException("Jmx service url created " + serviceUrl, e);
        }
    }

    public JmxReporter getReporter() {
        return this.reporter;
    }

    public void start() {
        ValidationUtils.checkArgument(this.reporter != null && this.connector != null, "reporter or connector cannot be null!");
        try {
            this.connector.start();
            this.reporter.start();
        }
        catch (Exception e) {
            throw new HoodieException("connector or reporter start failed", e);
        }
    }

    public void stop() throws IOException {
        this.stopConnector();
        this.stopReport();
        this.stopRmiRegistry();
    }

    private void stopRmiRegistry() {
        if (this.rmiRegistry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            catch (NoSuchObjectException e) {
                throw new HoodieException("Could not un-export our RMI registry", e);
            }
            finally {
                this.rmiRegistry = null;
            }
        }
    }

    private void stopConnector() throws IOException {
        if (this.connector != null) {
            try {
                this.connector.stop();
            }
            finally {
                this.connector = null;
            }
        }
    }

    private void stopReport() {
        if (this.reporter != null) {
            try {
                this.reporter.stop();
            }
            finally {
                this.reporter = null;
            }
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private MBeanServer mBeanServer;
        private String host;
        private int port;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder registerWith(MBeanServer mBeanServer) {
            this.mBeanServer = mBeanServer;
            return this;
        }

        public JmxReporterServer build() {
            Objects.requireNonNull(this.registry, "registry cannot be null!");
            Objects.requireNonNull(this.mBeanServer, "mBeanServer cannot be null!");
            ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(this.host), "host cannot be null or empty!");
            return new JmxReporterServer(this.registry, this.host, this.port, this.mBeanServer);
        }
    }
}

